<?php
/**
 * Environment Variable set here
 */
putenv("APPLICATION_ENV=production");


/**
 * Display all errors when APPLICATION_ENV is development.
 */

if (getenv('APPLICATION_ENV') == 'development') {
    error_reporting(E_ALL);
    ini_set("display_errors", 1);
}
// error_reporting(E_ALL);
// ini_set("display_errors", 1);
    
/**
 * This makes our life easier when dealing with paths. Everything is relative
 * to the application root now.
 */

// chdir(dirname(__DIR__));
chdir(__DIR__);

// echo __DIR__; die;

// Setup autoloading
// require 'init_autoloader.php';

// Composer autoloading
if (file_exists(__DIR__ . '/vendor/autoload.php')) {
    $loader = include __DIR__.'/vendor/autoload.php';
}

$zf2Path = false;

if (is_dir(__DIR__.'/vendor/ZF2/library')) {
    $zf2Path = __DIR__.'/vendor/ZF2/library';
} elseif (getenv('ZF2_PATH')) {      // Support for ZF2_PATH environment variable or git submodule
    $zf2Path = getenv('ZF2_PATH');
} elseif (function_exists('zend_deployment_library_path') && zend_deployment_library_path ('Zend Framework 2')) {
    $zf2Path = zend_deployment_library_path ('Zend Framework 2');
} elseif (get_cfg_var('zf2_path')) { // Support for zf2_path directive value
    $zf2Path = get_cfg_var('zf2_path');
}

if ($zf2Path) {
    if (isset($loader)) {
        $loader->add('Zend', $zf2Path);
    } else {
        include $zf2Path . '/Zend/Loader/AutoloaderFactory.php';
        Laminas\Loader\AutoloaderFactory::factory(array(
            'Laminas\Loader\StandardAutoloader' => array(
                'autoregister_zf' => true
            )
        ));
    }
}

if (!class_exists('Laminas\Loader\AutoloaderFactory')) {
    throw new RuntimeException('Unable to load ZF2. Run `php composer.phar install` or define a ZF2_PATH environment variable.');
}



// Load Laminas application config
$appConfig = require __DIR__ . '/config/application.config.php';
// echo "<pre>"; print_r($appConfig); die();

// Run the application!
Laminas\Mvc\Application::init($appConfig)->run();

// Run the application!
// Laminas\Mvc\Application::init(require 'config/application.config.php')->run();
