<?php

return [
    'controllers' => [
        'invokables' => [
            'API\Controller\User' => API\Controller\UserController::class,
            'API\Controller\InvalidIdentity' => API\Controller\InvalidIdentityController::class,
            'API\Controller\TaskType' => API\Controller\TaskTypeController::class,
            'API\Controller\TourType' => API\Controller\TourTypeController::class,
            'API\Controller\Organizations' => API\Controller\OrganizationController::class,
            'API\Controller\DayType' => API\Controller\DayTypeController::class,
            'API\Controller\Seasons' => API\Controller\SeasonsController::class,
            'API\Controller\Shifts' => API\Controller\ShiftsController::class,
            'API\Controller\Tasks' => API\Controller\TasksController::class,
            'API\Controller\WeekdayAssignments' => API\Controller\WeekdayAssignmentsController::class,
            'API\Controller\ShiftAssignments' => API\Controller\ShiftAssignmentsController::class,
            'API\Controller\GuideAvailabilities' => API\Controller\GuideAvailabilitiesController::class,
            'API\Controller\ReservedDates' => API\Controller\ReservedDatesController::class,
            'API\Controller\GuideAssignments' => API\Controller\GuideAssignmentsController::class,
            'API\Controller\GuideShiftAssignments' => API\Controller\GuideShiftAssignmentsController::class,
            'API\Controller\GuideTimeSheets' => API\Controller\GuideTimeSheetsController::class,
            'API\Controller\Availabilities' => API\Controller\AvailabilitiesController::class,
            'API\Controller\TaskAssignment' => API\Controller\TaskAssignmentController::class,
            'API\Controller\TicketTypes' => API\Controller\TicketTypeController::class,
            'API\Controller\GuideAssignmentTickets' => API\Controller\GuideAssignmentTicketsController::class,
            'API\Controller\EmailMessage' => API\Controller\EmailMessageController::class,
            'API\Controller\EmailTemplate' => API\Controller\EmailTemplateController::class,
            'API\Controller\AutomatedEmail' => API\Controller\AutomatedEmailController::class,
            'API\Controller\TicketReconciliationMap' => API\Controller\TicketReconciliationMapController::class
        ],
    ],
    'router' => [
        'routes' => [
            'rest-api' => [
                'type'    => 'segment',
                'options' => [
                    'route'    => '/api/[:controller[/][:id[/]]]',
                    'constraints' => [
                        'controller' => '[a-zA-Z][-a-zA-Z0-9_]*',
                        'id'         => '[-a-zA-Z0-9_.@]*'
                    ],
                    'defaults' => [
                        '__NAMESPACE__' => 'API\Controller',
                    ],
                ],
            ],
        ],
    ],
    'view_manager' => [
        'strategies' => [
            'ViewJsonStrategy',
        ],
    ],
];