<?php

namespace API\Controller;

use API\Exception\DeletedEntryNotificationException;
use API\Exception\SystemErrorException;
use Application\Exception\EntryNotFoundException;
use Application\Model\DayType;
use Application\Model\DayTypesTable;
use Laminas\Db\ResultSet\ResultSet;
use Laminas\Mvc\Controller\AbstractRestfulController;
use Laminas\View\Model\JsonModel;

class DayTypeController extends AbstractRestfulController
{
    public function get($id)
    {
        try
        {
            /**
             * @var $dayTypeTable DayTypesTable
             */
            $dayTypeTable = $this->serviceLocator->get('Application/Model/DayTypeTable');

            /**
             * @var $dayType DayType
             */
            $dayType = $dayTypeTable->fetchOne($id);

            return new JsonModel($dayType->toArray());

        } catch (EntryNotFoundException $notFoundException)
        {
            return new \API\Exception\EntryNotFoundException($this->response,
                "UNABLE TO FIND ENTRY");
        } catch (\Exception $exception)
        {
            return new JsonModel(new SystemErrorException($this->response, $exception));
        }
    }

    public function getList()
    {
        try
        {
            /**
             * @var $dayTypeTable DayTypesTable
             */
            $dayTypeTable = $this->serviceLocator->get('Application/Model/DayTypeTable');

            /**
             * @var $resultSet ResultSet
             */
            $resultSet = $dayTypeTable->fetchAll();

            $return = [];

            /**
             * @var $dayType DayType
             */
            while ($dayType = $resultSet->current())
            {
                $return[] = $dayType->toArray();
                $resultSet->next();
            }

            return new JsonModel($return);

        } catch (EntryNotFoundException $notFoundException)
        {
            return new \API\Exception\EntryNotFoundException($this->response,
                "UNABLE TO FIND ENTRY");
        } catch (\Exception $exception)
        {
            return new JsonModel(new SystemErrorException($this->response, $exception));
        }
    }

    public function create($data)
    {
        try
        {
            /**
             * @var $dayTypeTable DayTypesTable
             */
            $dayTypeTable = $this->serviceLocator->get('Application/Model/DayTypeTable');

            $dayType = new DayType();
            $dayType->exchangeArray($data);
            $dayType->id = null;
            $dayType->status = 1;
            $dayType->createdate = date('Y-m-d H:i:s');
            $dayType->modifydate = date('Y-m-d H:i:s');

            $dayTypeTable->saveOne($dayType);

            return new JsonModel($dayType->toArray());

        } catch (\Exception $exception)
        {
            return new JsonModel(new SystemErrorException($this->response, $exception));
        }
    }

    public function update($id, $data)
    {
        try
        {
            /**
             * @var $dayTypeTable DayTypesTable
             */
            $dayTypeTable = $this->serviceLocator->get('Application/Model/DayTypeTable');

            $toUpdateDayType = new DayType();
            $toUpdateDayType->exchangeArray($data);

            /**
             * @var $oldDayType DayType
             */
            $oldDayType = $dayTypeTable->fetchOne($id);
            $oldDayType->name = $toUpdateDayType->name;
            $oldDayType->status = $toUpdateDayType->status;
            $oldDayType->modifydate = date('Y-m-d H:i:s');

            $dayTypeTable->saveOne($oldDayType);

            return new JsonModel($oldDayType->toArray());

        } catch (EntryNotFoundException $notFoundException)
        {
            return new \API\Exception\EntryNotFoundException($this->response,
                "UNABLE TO FIND ENTRY");
        } catch (\Exception $exception)
        {
            return new JsonModel(new SystemErrorException($this->response, $exception));
        }
    }

    public function delete($id)
    {
        try {

            /**
             * @var $dayTypeTable DayTypesTable
             */
            $dayTypeTable = $this->serviceLocator->get('Application/Model/DayTypeTable');


            $dayTypeTable->deleteOne($id);

            return new JsonModel(new DeletedEntryNotificationException($this->response, "Day Type Deleted"));

        } catch (EntryNotFoundException $notFoundException)
        {
            return new \API\Exception\EntryNotFoundException($this->response,
                "UNABLE TO FIND ENTRY");
        } catch (\Exception $exception)
        {
            return new JsonModel(new SystemErrorException($this->response, $exception));
        }

    }
}