<?php

namespace API\Controller;

use API\Exception\SystemErrorException;
use Application\Exception\EntryNotFoundException;
use Application\Model\EmailTemplate;
use Application\Model\EmailTemplateTable;
use Application\Services\TemplateImageResizer;
use Laminas\Db\ResultSet\ResultSet;
use Laminas\Mvc\Controller\AbstractRestfulController;
use Laminas\View\Model\JsonModel;

class EmailTemplateController extends AbstractRestfulController
{
    public function get($id)
    {
        try
        {

            /**
             * @var $emailTemplateTable EmailTemplateTable
             */
            $emailTemplateTable = $this->serviceLocator->get('Application\Model\EmailTemplateTable');

            /**
             * @var $emailTemplate EmailTemplate
             */
            $emailTemplate = $emailTemplateTable->fetchOne($id);
            $emailTemplate->allowed_variables = json_decode($emailTemplate->allowed_variables);

            return new JsonModel($emailTemplate->toArray());

        } catch (EntryNotFoundException $notFoundException)
        {
            return new \API\Exception\EntryNotFoundException($this->response,
                "UNABLE TO FIND ENTRY");
        } catch (\Exception $exception)
        {
            return new JsonModel(new SystemErrorException($this->response, $exception));
        }
    }

    public function getList()
    {
        try
        {
            /**
             * @var $emailTemplateTable EmailTemplateTable
             */
            $emailTemplateTable = $this->serviceLocator->get('Application\Model\EmailTemplateTable');

            $return = [];

            /**
             * @var $resultSet ResultSet
             */
            $resultSet = $emailTemplateTable->fetchAll();

            /**
             * @var $emailTemplate EmailTemplate
             */
            while ($emailTemplate = $resultSet->current())
            {
                $emailTemplate->allowed_variables = json_decode($emailTemplate->allowed_variables);
                $return[] = $emailTemplate->toArray();
                $resultSet->next();
            }

            return new JsonModel($return);

        } catch (EntryNotFoundException $notFoundException)
        {
            return new \API\Exception\EntryNotFoundException($this->response,
                "UNABLE TO FIND ENTRY");
        } catch (\Exception $exception)
        {
            return new JsonModel(new SystemErrorException($this->response, $exception));
        }
    }

    public function update($id, $data)
    {
        try
        {

            /**
             * @var $emailTemplateTable EmailTemplateTable
             */
            $emailTemplateTable = $this->serviceLocator->get('Application\Model\EmailTemplateTable');

            /**
             * @var $oldTemplate EmailTemplate
             */
            $oldTemplate = $emailTemplateTable->fetchOne($id);

            $emailTemplate = new EmailTemplate();
            $emailTemplate->exchangeArray($data);

            $emailTemplate->description = $oldTemplate->description;
            $emailTemplate->allowed_variables = $oldTemplate->allowed_variables;
            $emailTemplate->type = $oldTemplate->type;

            if ($emailTemplate->content !== '')
            {
                $templateImageResizer = new TemplateImageResizer($emailTemplate->content);
                $emailTemplate->content = $templateImageResizer->getParsedTemplate();
            }

            $emailTemplateTable->saveOne($emailTemplate);

            return new JsonModel($emailTemplate->toArray());


        } catch (EntryNotFoundException $notFoundException)
        {
            return new \API\Exception\EntryNotFoundException($this->response,
                "UNABLE TO FIND ENTRY");
        } catch (\Exception $exception)
        {
            return new JsonModel(new SystemErrorException($this->response, $exception));
        }
    }

}
