<?php

namespace API\Controller;

use API\Exception\AccessDeniedException;
use API\Exception\DeletedEntryNotificationException;
use API\Exception\SystemErrorException;
use Application\Exception\EntryNotFoundException;
use Application\Model\Admin;
use Application\Model\GuideAvailability;
use Application\Model\GuideAvailabilityTable;
use Application\Services\DatePickerFormatter;
use Laminas\Db\ResultSet\ResultSet;
use Laminas\Mvc\Controller\AbstractRestfulController;
use Laminas\View\Model\JsonModel;

class GuideAvailabilitiesController extends AbstractRestfulController {
	public function get($id) {
		try
		{

			/**
			 * @var $guideAvailabilityTable GuideAvailabilityTable
			 */
			$guideAvailabilityTable = $this->serviceLocator->get('Application\Model\GuideAvailabilityTable');

			/**
			 * @var $guideAvailability GuideAvailability
			 */
			$guideAvailability = $guideAvailabilityTable->fetchOne($id);

			$guideAvailability->availabilitydate = DatePickerFormatter::toDatePickerDate($guideAvailability->availabilitydate);

			return new JsonModel($guideAvailability->toArray());

		} catch (EntryNotFoundException $notFoundException) {
			return new \API\Exception\EntryNotFoundException($this->response,
				"UNABLE TO FIND ENTRY");
		} catch (\Exception $exception) {
			return new JsonModel(new SystemErrorException($this->response, $exception));
		}
	}

	public function getList() {
		try
		{

			/**
			 * @var $guideAvailabilityTable GuideAvailabilityTable
			 */
			$guideAvailabilityTable = $this->serviceLocator->get('Application\Model\GuideAvailabilityTable');

			$guideId = $this->request->getQuery('guide_id', null);
			$startDate = $this->request->getQuery('startDate', null);
			$endDate = $this->request->getQuery('endDate', null);

			$startDate = $startDate != null ? strtotime($startDate) : null;
			$endDate = $endDate != null ? strtotime($endDate) : null;

			/**
			 * @var $resultSet ResultSet
			 */
			$resultSet = $guideAvailabilityTable->fetchAllByGuideId($guideId, $startDate, $endDate);

			$results = [];

			/**
			 * @var $guideAvailability GuideAvailability
			 */
			while ($guideAvailability = $resultSet->current()) {
				$guideAvailability->availabilitydate = DatePickerFormatter::toDatePickerDate($guideAvailability->availabilitydate);
				$results[] = $guideAvailability->toArray();
				$resultSet->next();
			}

			return new JsonModel($results);

		} catch (EntryNotFoundException $notFoundException) {
			return new \API\Exception\EntryNotFoundException($this->response,
				"UNABLE TO FIND ENTRY");
		} catch (\Exception $exception) {
			return new JsonModel(new SystemErrorException($this->response, $exception));
		}
	}

	public function create($data) {
		try
		{
			/**
			 * @var $activeAdmin Admin
			 */
			$activeAdmin = $this->serviceLocator->get('ActiveAdmin');

			if (!$activeAdmin->enabled) {
				return new JsonModel(new AccessDeniedException($this->response, 'Administrative Access Required'));
			}

			/**
			 * @var $guideAvailabilityTable GuideAvailabilityTable
			 */
			$guideAvailabilityTable = $this->serviceLocator->get('Application\Model\GuideAvailabilityTable');

			$guideAvailability = new GuideAvailability();
			$guideAvailability->exchangeArray($data);
			$guideAvailability->id = null;
			$guideAvailability->availabilitydate = DatePickerFormatter::toSqlDate($guideAvailability->availabilitydate);
			$guideAvailability->createdate = date("Y-m-d");
			$guideAvailability->modifydate = date("Y-m-d");
			$guideAvailability->starttime = $guideAvailability->starttime ?: null;
			$guideAvailability->endtime = $guideAvailability->endtime ?: null;

			$guideAvailabilityTable->saveOne($guideAvailability);

			$guideAvailability->availabilitydate = DatePickerFormatter::toDatePickerDate($guideAvailability->availabilitydate);

			return new JsonModel($guideAvailability->toArray());
		} catch (\Exception $exception) {
			return new JsonModel(new SystemErrorException($this->response, $exception));
		}
	}

	public function update($id, $data) {
		try
		{

			/**
			 * @var $activeAdmin Admin
			 */
			$activeAdmin = $this->serviceLocator->get('ActiveAdmin');

			if (!$activeAdmin->enabled) {
				return new JsonModel(new AccessDeniedException($this->response, 'Administrative Access Required'));
			}

			/**
			 * @var $guideAvailabilityTable GuideAvailabilityTable
			 */
			$guideAvailabilityTable = $this->serviceLocator->get('Application\Model\GuideAvailabilityTable');

			$guideAvailability = new GuideAvailability();
			$guideAvailability->exchangeArray($data);
			$guideAvailability->availabilitydate = DatePickerFormatter::toSqlDate($guideAvailability->availabilitydate);
			$guideAvailability->modifydate = date("Y-m-d");

			$guideAvailabilityTable->saveOne($guideAvailability);

			$guideAvailability->availabilitydate = DatePickerFormatter::toDatePickerDate($guideAvailability->availabilitydate);

			return new JsonModel($guideAvailability->toArray());

		} catch (EntryNotFoundException $notFoundException) {
			return new \API\Exception\EntryNotFoundException($this->response,
				"UNABLE TO FIND ENTRY");
		} catch (\Exception $exception) {
			return new JsonModel(new SystemErrorException($this->response, $exception));
		}
	}

	public function delete($id) {
		try {

			/**
			 * @var $activeAdmin Admin
			 */
			$activeAdmin = $this->serviceLocator->get('ActiveAdmin');

			if (!$activeAdmin->enabled) {
				return new JsonModel(new AccessDeniedException($this->response, 'Administrative Access Required'));
			}

			/**
			 * @var $guideAvailabilityTable GuideAvailabilityTable
			 */
			$guideAvailabilityTable = $this->serviceLocator->get('Application\Model\GuideAvailabilityTable');

			$guideAvailabilityTable->deleteOne($id);

			return new JsonModel(new DeletedEntryNotificationException($this->response, "Guide Availability removed"));

		} catch (EntryNotFoundException $notFoundException) {
			return new \API\Exception\EntryNotFoundException($this->response,
				"UNABLE TO FIND ENTRY");
		} catch (\Exception $exception) {
			return new JsonModel(new SystemErrorException($this->response, $exception));
		}

	}
}
