<?php

namespace API\Controller;

use API\Exception\AccessDeniedException;
use API\Exception\UnauthorizedException;
use Laminas\Mvc\Controller\AbstractRestfulController;
use Laminas\View\Model\JsonModel;

class InvalidIdentityController extends AbstractRestfulController
{
    public function get($id)
    {
        return $this->goAction();
    }

    public function goAction()
    {
        $unauthorisedException = new UnauthorizedException($this->response);
        return new JsonModel($unauthorisedException);
    }

    public function adminRequiredAction()
    {
        return new JsonModel(new AccessDeniedException($this->response, 'Administrative Access Required'));

    }
}