<?php

namespace API\Controller;

use API\Exception\AccessDeniedException;
use API\Exception\DeletedEntryNotificationException;
use API\Exception\SystemErrorException;
use Application\Exception\EntryNotFoundException;
use Application\Model\Admin;
use Application\Model\TaskAssignment;
use Application\Model\TaskAssignmentTable;
use Application\Services\DatePickerFormatter;
use Laminas\Db\ResultSet\ResultSet;
use Laminas\Mvc\Controller\AbstractRestfulController;
use Laminas\View\Model\JsonModel;

class TaskAssignmentController extends AbstractRestfulController
{
    public function get($id)
    {
        try
        {
            /**
             * @var $taskAssignmentTable TaskAssignmentTable
             */
            $taskAssignmentTable = $this->serviceLocator->get('Application\Model\TaskAssignmentTable');
            //echo "<pre>"; print_r($taskAssignmentTable); exit();

            /**
             * @var $taskAssignment TaskAssignment
             */
            $taskAssignment = $taskAssignmentTable->fetchOne($id);
            $taskAssignment->assignmentdate = DatePickerFormatter::toDatePickerDate($taskAssignment->assignmentdate);


            return new JsonModel($taskAssignment->toArray());

        } catch (EntryNotFoundException $notFoundException)
        {
            return new \API\Exception\EntryNotFoundException($this->response,
                "UNABLE TO FIND ENTRY");
        } catch (\Exception $exception)
        {
            return new JsonModel(new SystemErrorException($this->response, $exception));
        }
    }

    public function getList()
    {
        try
        {

            /**
             * @var $taskAssignmentTable TaskAssignmentTable
             */
            $taskAssignmentTable = $this->serviceLocator->get('Application\Model\TaskAssignmentTable');


            $startDate = $this->request->getQuery('startDate', null);
            $endDate = $this->request->getQuery('endDate', null);
            $searchQuery = $this->request->getQuery('searchQuery', null);

            $startDate = $startDate != null ? strtotime($startDate) : null;
            $endDate = $endDate != null ? strtotime($endDate) : null;

            /**
             * @var $resultSet ResultSet
             */
            $resultSet = $taskAssignmentTable->fetchCurrent($startDate, $endDate, $searchQuery);

            $return = [];

            /**
             * @var $taskAssignment TaskAssignment
             */
            while ($taskAssignment = $resultSet->current())
            {
                $taskAssignment->assignmentdate = DatePickerFormatter::toDatePickerDate($taskAssignment->assignmentdate);
                $return[] = $taskAssignment->toArray();
                $resultSet->next();
            }

            return new JsonModel($return);

        } catch (EntryNotFoundException $notFoundException)
        {
            return new \API\Exception\EntryNotFoundException($this->response,
                "UNABLE TO FIND ENTRY");
        } catch (\Exception $exception)
        {
            return new JsonModel(new SystemErrorException($this->response, $exception));
        }
    }

    public function create($data)
    {
        try
        {

            /**
             * @var $activeAdmin Admin
             */
            $activeAdmin = $this->serviceLocator->get('ActiveAdmin');

            if (!$activeAdmin->enabled)
            {
                return new JsonModel(new AccessDeniedException($this->response, 'Administrative Access Required'));
            }

            /**
             * @var $taskAssignmentTable TaskAssignmentTable
             */
            $taskAssignmentTable = $this->serviceLocator->get('Application\Model\TaskAssignmentTable');

            $taskAssignment = new TaskAssignment();
            $taskAssignment->exchangeArray($data);
            $taskAssignment->id = null;
            $taskAssignment->createdate = date("Y-m-d");
            $taskAssignment->modifydate = date("Y-m-d");
            $taskAssignment->assignmentdate = DatePickerFormatter::toSqlDate($taskAssignment->assignmentdate);
            $taskAssignment->confirmationemaildate = null;
            $taskAssignment->thankyouemaildate = null;
            $taskAssignment->guide_id = null;
            $taskAssignment->shiftassignment_id = null;
            $taskAssignment->task_id = null;
            $taskAssignment->status = 1;

            $taskAssignmentTable->saveOne($taskAssignment);

            $taskAssignment->assignmentdate = DatePickerFormatter::toDatePickerDate($taskAssignment->assignmentdate);


            return new JsonModel($taskAssignment->toArray());

        } catch (\Exception $exception)
        {
            return new JsonModel(new SystemErrorException($this->response, $exception));
        }
    }

    public function update($id, $data)
    {
        try
        {

            /**
             * @var $activeAdmin Admin
             */
            $activeAdmin = $this->serviceLocator->get('ActiveAdmin');

            if (!$activeAdmin->enabled)
            {
                return new JsonModel(new AccessDeniedException($this->response, 'Administrative Access Required'));
            }

            /**
             * @var $taskAssignmentTable TaskAssignmentTable
             */
            $taskAssignmentTable = $this->serviceLocator->get('Application\Model\TaskAssignmentTable');


            $taskAssignment = new TaskAssignment();
            $taskAssignment->exchangeArray($data);

            /**
             * @var $oldTaskAssignment TaskAssignment
             */
            $oldTaskAssignment = $taskAssignmentTable->fetchOne($id);

            $taskAssignment->createdate = $oldTaskAssignment->createdate;
            $taskAssignment->thankyouemaildate = $oldTaskAssignment->thankyouemaildate ?: $taskAssignment->thankyouemaildate;
            $taskAssignment->confirmationemaildate = $oldTaskAssignment->confirmationemaildate ?: $taskAssignment->confirmationemaildate;
            $taskAssignment->guide_id = $oldTaskAssignment->guide_id;
            $taskAssignment->shiftassignment_id = $taskAssignment->shiftassignment_id ?: null;
            $taskAssignment->guide_id = $taskAssignment->guide_id ?: null;
            $taskAssignment->task_id = $taskAssignment->task_id ?: null;
            $taskAssignment->paymentstatus = ($taskAssignment->paymentstatus !== false) ? $taskAssignment->paymentstatus : null;

            $taskAssignment->confirmationemaildate = $taskAssignment->confirmationemaildate ?: null;
            $taskAssignment->thankyouemaildate = $taskAssignment->thankyouemaildate ?: null;

            $taskAssignment->modifydate = date("Y-m-d");

            $taskAssignment->assignmentdate = DatePickerFormatter::toSqlDate($taskAssignment->assignmentdate);


            $taskAssignmentTable->saveOne($taskAssignment);



            return new JsonModel($taskAssignment->toArray());

        } catch (EntryNotFoundException $notFoundException)
        {
            return new \API\Exception\EntryNotFoundException($this->response,
                "UNABLE TO FIND ENTRY");
        } catch (\Exception $exception)
        {
            return new JsonModel(new SystemErrorException($this->response, $exception));
        }
    }

    public function delete($id)
    {
        try {
            /**
             * @var $activeAdmin Admin
             */
            $activeAdmin = $this->serviceLocator->get('ActiveAdmin');

            if (!$activeAdmin->enabled)
            {
                return new JsonModel(new AccessDeniedException($this->response, 'Administrative Access Required'));
            }

            /**
             * @var $taskAssignmentTable TaskAssignmentTable
             */
            $taskAssignmentTable = $this->serviceLocator->get('Application\Model\TaskAssignmentTable');

            $taskAssignmentTable->deleteOne($id);

            return new JsonModel(new DeletedEntryNotificationException($this->response, "Deleted TaskAssignment"));

        } catch (EntryNotFoundException $notFoundException)
        {
            return new \API\Exception\EntryNotFoundException($this->response,
                "UNABLE TO FIND ENTRY");
        } catch (\Exception $exception)
        {
            return new JsonModel(new SystemErrorException($this->response, $exception));
        }

    }
}
