<?php

namespace API\Controller;

use API\Exception\SystemErrorException;
use Application\Exception\EntryNotFoundException;
use Application\Model\TicketReconciliationMap;
use Application\Model\TicketReconciliationMapTable;
use Laminas\Db\ResultSet\ResultSet;
use Laminas\Mvc\Controller\AbstractRestfulController;
use Laminas\View\Model\JsonModel;

class TicketReconciliationMapController extends AbstractRestfulController
{
    public function getList()
    {
        try
        {

            $startDate = $this->request->getQuery('startDate');
            $endDate = $this->request->getQuery('endDate');

            $startDate = $startDate != null ? strtotime($startDate) : null;
            $endDate = $endDate != null ? strtotime($endDate) : null;

            /**
             * @var $ticketReconciliationMapTable TicketReconciliationMapTable
             */
            $ticketReconciliationMapTable = $this->serviceLocator->get('Application\Model\TicketReconciliationMapTable');

            /**
             * @var $ticketReconciliationResultSet ResultSet
             */
            $ticketReconciliationResultSet = $ticketReconciliationMapTable->fetchTicketReconciliationMap($startDate, $endDate);

            /**
             * @var $ticketReconciliationMapList TicketReconciliationMap[]
             */
            $ticketReconciliationMapList = [];

            /**
             * @var $ticketReconciliationMap TicketReconciliationMap
             */
            while ($ticketReconciliationMap = $ticketReconciliationResultSet->current())
            {
                $ticketReconciliationMapList[] = $ticketReconciliationMap;
                $ticketReconciliationResultSet->next();
            }

            return new JsonModel($ticketReconciliationMapList);

        } catch (EntryNotFoundException $notFoundException)
        {
            return new \API\Exception\EntryNotFoundException($this->response,
                "UNABLE TO FIND ENTRY");
        } catch (\Exception $exception)
        {
            return new JsonModel(new SystemErrorException($this->response, $exception));
        }
    }
}
