<?php
namespace Application\Controller;

use Application\Model\User;
use Laminas\Mvc\Controller\AbstractActionController;
use Laminas\View\Model\ViewModel;

class MembersController extends AbstractActionController
{
    /* properties */


    /* actions */
    public function indexAction()
    {
        if (!$this->serviceLocator->get('AuthService')->hasIdentity())
        {
            return $this->redirect()->toUrl('/wstr/application/login');
        }

        /**
         * @var $activeUser User
         */
        $activeUser = $this->serviceLocator->get('ActiveUser');

        $this->layout('layout/members');
        $this->layout()->setVariable('user_id', $activeUser->id);

        return new ViewModel();
    }

}
