<?php

namespace Application\Factories;

use Laminas\ServiceManager\FactoryInterface;
use Laminas\ServiceManager\ServiceLocatorInterface;

class AuthServiceFactory implements FactoryInterface
{
    static $authService = null;

    public function createService(ServiceLocatorInterface $serviceLocator)
    {
        if (self::$authService == null)
        {
            $usernameExp = new \Laminas\Db\Sql\Expression('LOWER(username)');

            $dbAdapter = $serviceLocator->get('Laminas\Db\Adapter\Adapter');
            $dbAuthAdapter = new \Laminas\Authentication\Adapter\DbTable\CredentialTreatmentAdapter(
                $dbAdapter,
                'users',
                $usernameExp,
                'password'
            );
            $authService = new \Laminas\Authentication\AuthenticationService();
            $authService->setAdapter($dbAuthAdapter);
            $authService->setStorage($serviceLocator->get('Application\Model\SessionStorage'));
            self::$authService = $authService;
        }
        return self::$authService;
    }
}