<?php

namespace Application\Factories\Mail\Services\Cron;

use Application\Services\Mail\Cron\TaskScheduleFutureMailer;
use Application\Services\Mail\NullMailer;
use Laminas\ServiceManager\FactoryInterface;
use Laminas\ServiceManager\ServiceLocatorInterface;

class TaskScheduleFutureMailerFactory implements FactoryInterface
{
    public function createService(ServiceLocatorInterface $serviceLocator)
    {
        $config = $serviceLocator->get('config');
        $disableMail = $config['smtp_service']['disable_admin_mail'];
        if ($disableMail)
        {
            $mailer = new NullMailer($serviceLocator);
            return $mailer;
        }
        $mailer = new TaskScheduleFutureMailer($serviceLocator);
        return $mailer;
    }
}