<?php

namespace Application\Model;

/**
 * Provides access to the user table
 *
 */
class AdminTable extends StandardTable
{

    public function fetchOne($id)
    {
        $id = (int) $id;
        $rowset = $this->tableGateway->select(["user_id" => $id]);
        $row = $rowset->current();
        if (! $row)
        {
            $admin = new Admin();
            $admin->user_id = $id;
            $admin->enabled = 0;
            return $admin;
        }
        return $row;
    }

    public function saveOne(StandardEntry $tableEntry)
    {
        $id = (int) $tableEntry->user_id;
        if ($id == 0)
        {
            $this->tableGateway->insert($tableEntry->toArray());
            $tableEntry->user_id = $this->tableGateway->lastInsertValue;
        }
        else
        {
            if ($this->fetchOne($id))
            {
                $this->tableGateway->update($tableEntry->toArray(), ['user_id' => $id]);
            }
        }
    }

    public function deleteOne($id)
    {
        return $this->tableGateway->delete(['user_id' => (int) $id]);
    }
}