<?php

namespace Application\Model;

class GuideAssignmentTable extends StandardTable {
	public function fetchAllByGuideId($guide_id) {
		return $this->tableGateway->select(function ($select) use ($guide_id) {
			if ((int) $guide_id > 0) {
				return $select->where(['guide_id' => (int) $guide_id]);
			} else {
				return $select;
			}

		});
	}

	public function fetchOneByAssignmentId($assignment_id) {
		return $this->tableGateway->select(function ($select) use ($assignment_id) {
			return $select->where(['taskassignment_id' => $assignment_id]);
		})->current();
	}

	public function fetchAllByAssignmentIds($assignmentIds, $live = null) {
		return $this->tableGateway->select(function ($select) use ($assignmentIds, $live) {
			if ($live) {
				$select->where(['status' => (int) $live]);
			}

			return $select->where->in('taskassignment_id', $assignmentIds);
		});
	}

}
