<?php

namespace Application\Model;

class GuideShiftAssignmentTable extends StandardTable
{
    public function fetchAllByShiftAssignmentId($shiftassignment_id)
    {
        return $this->tableGateway->select(function($select) use ($shiftassignment_id)
        {
            $select->where(['shiftassignment_id' => $shiftassignment_id]);
        });
    }

    public function fetchList($shiftAssignmentIds)
    {
        return $this->tableGateway->select(function($select) use ($shiftAssignmentIds)
        {
            if (is_array($shiftAssignmentIds) && sizeof($shiftAssignmentIds))
                $select->where->in('shiftassignment_id', $shiftAssignmentIds);

            return $select;
        });
    }

    public function fetchAllByGuideId($guide_id)
    {
        return $this->tableGateway->select(function($select) use ($guide_id)
        {
            if ((int) $guide_id > 0)
                return $select->where(['guide_id' => (int) $guide_id]);
            else
                return $select;
        });

    }
}