<?php

namespace Application\Model;

use Laminas\Db\Sql\Select;

class SeasonTaskAssignmentMapTable extends StandardTable
{
    public function getSeasonTaskMap($season_id)
    {

        /**
         * @var $select Select
         */
        return $this->tableGateway->select(function($select) use ($season_id)
        {
            $select->join('weekdayassignments', 'weekdayassignments.season_id = seasons.id', [
                'season_id', 'dayofweek'
            ], Select::JOIN_LEFT);

            $select->join('shiftassignments', 'shiftassignments.weekdayassignment_id = weekdayassignments.id', [
                    'shiftassignment_id' => 'id',
                    'weekdayassignment_id' => 'weekdayassignment_id',
                    'shift_id' => 'shift_id',
                    'guide_id' => 'guide_id'
                ], Select::JOIN_LEFT);

            $select->join('tasks', 'tasks.shift_id = shiftassignments.shift_id', [
                'task_id' => 'id',
                'tasktype' => 'tasktype',
                'starttime' => 'starttime',
                'endtime' => 'endtime'
            ], Select::JOIN_LEFT);

            $select->where(['seasons.id' => $season_id, 'tasks.status' => 1]);

//            $query = @$select->getSqlString();
            return $select;
        });
    }
}