<?php

namespace Application\Model;

class TaskAssignmentTable extends StandardTable
{
    public function deleteMatching($organization_id, $shiftassignment_id)
    {
        return $this->tableGateway->delete(['organization_id' => $organization_id, 'shiftassignment_id' => $shiftassignment_id]);
    }

    public function fetchMatching($organization_id, $shiftassignment_id)
    {
        return $this->tableGateway->select(function($select) use ($organization_id, $shiftassignment_id)
        {
            $select->where([
                'organization_id' => $organization_id,
                'shiftassignment_id' => $shiftassignment_id
            ]);

            return $select;
        });
    }

    public function fetchCurrent($startDate, $endDate, $searchQuery, $active = null)
    {

        return $this->tableGateway->select(function($select) use ($startDate, $endDate, $searchQuery, $active)
        {
            if ($searchQuery)
            {
                $select->where
                    ->nest
                        ->like('notes', sprintf("%%%s%%", $searchQuery))
                        ->or
                        ->like('tourname', sprintf("%%%s%%", $searchQuery))
                        ->or
                        ->like('tourcontactname', sprintf("%%%s%%", $searchQuery))
                    ->unnest;
            }

            if ($startDate) $select->where->greaterThanOrEqualTo('assignmentdate', date("Y-m-d", $startDate));
            if ($endDate) $select->where->lessThanOrEqualTo('assignmentdate', date("Y-m-d", $endDate));

            $select->order('tasktype ASC, tourtype ASC, assignmentdate DESC, starttime ASC');

//            $query = @$select->getSqlString();

            $select->limit(1000);
        });
    }

    public function get_all_records($startDate, $endDate, $searchQuery, $active = null)
    {
        return $this->tableGateway->select(function($select) use ($startDate, $endDate, $searchQuery, $active)
        {
            if ($startDate) $select->where->greaterThanOrEqualTo('assignmentdate', date("Y-m-d", $startDate));
            if ($endDate) $select->where->lessThanOrEqualTo('assignmentdate', date("Y-m-d", $endDate));

            $select->order('assignmentdate ASC');

            $select->limit(1000);
        });
    }
}