<?php

namespace Application\Services\Mail;

use Application\Model\Admin;
use Application\Model\AdminTable;
use Application\Model\EmailMessage;
use Application\Model\MessageRecipient;
use Application\Model\User;
use Application\Model\UserTable;
use Laminas\Db\ResultSet\ResultSet;

class ChangedPasswordNotificationMailer {

    protected $serviceLocator = null;

    public function __construct($serviceLocator)
    {
        $this->serviceLocator = $serviceLocator;
    }

    /**
     * We catch exceptions in this and allow it to fail gracefully
     *
     * @param User $passwordChangedUser
     */
    public function sendPasswordChangedNotice(User $passwordChangedUser)
    {
        try {

            $messageRecipients = [];

            /**
             * @var $usersTable UserTable
             */
            $usersTable = $this->serviceLocator->get('Application\Model\UserTable');
            /**
             * @var $adminsTable AdminTable
             */
            $adminsTable = $this->serviceLocator->get('Application/Model/AdminTable');

            /**
             * @var $resultSet ResultSet
             */
            $resultSet = $adminsTable->fetchAll();

            /**
             * @var $admin Admin
             */
            while ($admin = $resultSet->current())
            {
                if ($admin->enabled)
                {
                    /**
                     * @var $user User
                     */
                    $user = $usersTable->fetchOne($admin->user_id);
                    /**
                     * Don't want to send a mail to developer address
                     */
                    if (preg_match('/agilaz/', $user->email)) continue;

                    $messageRecipient = new MessageRecipient();
                    $messageRecipient->enabled = true;
                    $messageRecipient->id = $user->id;
                    $messageRecipient->name = $user->name;
                    $messageRecipient->email = "bheraram.worldweb@gmail.com"; // $user->email;

                    $messageRecipients[] = $messageRecipient;
                };

                $resultSet->next();
            }


            $emailMessage = new EmailMessage();
            $emailMessage->messageSubject = 'User Password Changed';
            $emailMessage->messageBody = sprintf("%s changed their password on %s",
                $passwordChangedUser->name, date('M j, Y h:i A'));
            $emailMessage->messageRecipients = $messageRecipients;


            $simpleEmailMessage = new SimpleEmailMessage($this->serviceLocator);
            $simpleEmailMessage->sendMail(null, $emailMessage);

        } catch (\Exception $exception)
        {
            echo "<pre>"; print_r($exception->getMessage()); die;
        }
    }

}