<?php

namespace Application\Services\Mail\Cron;

use Application\Model\EmailMessage;
use Application\Model\EmailTemplate;
use Application\Model\EmailTemplateTable;
use Application\Model\MessageRecipient;
use Application\Model\TaskAssignment;
use Application\Model\TaskAssignmentTable;
use Application\Model\User;
use Application\Services\Mail\GenericMailerInterface;
use Laminas\Db\ResultSet\ResultSet;
use Laminas\View\Model\ViewModel;

class ThankYouDaily extends GenericMailerInterface
{

    public function executeCronAction()
    {
        /**
         * @var $emailTemplateTable EmailTemplateTable
         */
        $emailTemplateTable = $this->serviceLocator->get('Application\Model\EmailTemplateTable');

        /**
         * @var $taskAssignmentTable TaskAssignmentTable
         */
        $taskAssignmentTable = $this->serviceLocator->get('Application\Model\TaskAssignmentTable');

        $messageDate = strtotime("-1 day");

        /**
         * @var $taskAssignmentsResultSet ResultSet
         */
        $taskAssignmentsResultSet = $taskAssignmentTable->fetchCurrent($messageDate, $messageDate, null, null);

        $failed_list = [];
        $completed_list = [];

        /**
         * @var $taskAssignment TaskAssignment
         */
        while ($taskAssignment = $taskAssignmentsResultSet->current())
        {

            /**
             * Only tours that aren't NA/Walk-up Tours
             */
            if ($taskAssignment->tasktype != 1 || $taskAssignment->tourtype == 0 || $taskAssignment->tourtype == 1)
            {
                $taskAssignmentsResultSet->next();
                continue;
            }

            try
            {
                if ($taskAssignment->tourcontactemail == '')
                {
                    $failed_list[] = $taskAssignment;
                    $taskAssignmentsResultSet->next();
                    continue;
                }

                $emailMessage = new EmailMessage();
                $emailMessage->messageSubject = $taskAssignment->getThankYouMessageSubject();

                $templateKey = $taskAssignment->getThankYouTemplateKey();

                if (!$templateKey)
                {
                    $failed_list[] = $taskAssignment;
                    $taskAssignmentsResultSet->next();
                    continue;
                }

                /**
                 * @var $emailTemplate EmailTemplate
                 */
                $emailTemplate = $emailTemplateTable->fetchTemplate($templateKey);

                if (!$emailTemplate instanceof  EmailTemplate)
                {
                    $failed_list[] = $taskAssignment;
                    $taskAssignmentsResultSet->next();
                    continue;
                }

                $emailMessage->messageBody = $emailTemplate->content;

                $recipient = new MessageRecipient();
                $recipient->enabled = true;
                $recipient->email = $taskAssignment->tourcontactemail;
                $recipient->name = $taskAssignment->tourcontactname;

                $emailMessage->messageRecipients = [ $recipient ];

                $this->sendMail(null, $emailMessage);

                $completed_list[] = $taskAssignment;

            } catch (\Exception $exception)
            {
                $failed_list[] = $taskAssignment;
            }

            $taskAssignmentsResultSet->next();
        }

        return [$completed_list, $failed_list];
    }

    /**
     * @param User|null $user
     * @param EmailMessage|null $emailMessage
     */
    public function sendMail(User $user = null, $emailMessage = null)
    {

        $config = $this->serviceLocator->get('config');
        $config = $config['smtp_service'];

        /**
         * @var $messageFooter EmailTemplate
         */
        $messageFooter = $this->serviceLocator->get('EmailFooterFactory');
        $messageFooter = $messageFooter->content;

        /**
         * @var $messageHeader EmailTemplate
         */
        $messageHeader = $this->serviceLocator->get('EmailHeaderFactory');
        $messageHeader = $messageHeader->content;


        $viewModel = new ViewModel();
        $viewModel->setTemplate('messaging/generic-message')
            ->setVariables([
                'messageBody' => $emailMessage->messageBody,
                'messageHeader' => $messageHeader,
                'messageFooter' => $messageFooter
            ]);


        $this->getMimeMessage(true)->addPart($this->getHtmlPart($viewModel, true));

        $mail = $this->getMailMessage(true);
        $mail->setFrom($config['default_from']);

        $messageRecipient = $emailMessage->messageRecipients[0];

        if (APPLICATION_ENVIRONMENT == 'production')
        {
            $mail->setTo(sprintf("%s <%s>", $messageRecipient->name, $messageRecipient->email));
        } else
        {
            $mail->setTo($config['debug_from']);
        }
        $mail->setBcc($config['default_from']);
        $mail->setSubject($emailMessage->messageSubject);
        $mail->setBody($this->getMimeMessage());
        // $mail->addCc("vipul.worldweb@gmail.com");
        
        $this->dispatchMail();

    }
}
