<?php

namespace Application\Services\Mail;

use Application\Model\EmailMessage;
use Application\Model\EmailTemplate;
use Application\Model\MessageRecipient;
use Application\Model\User;
use Laminas\View\Model\ViewModel;

class SimpleEmailMessage extends GenericMailerInterface
{
    /**
     * @param User $user
     * @param $emailData EmailMessage
     */
    public function sendMail(User $user = null, $emailData)
    {

        $config = $this->serviceLocator->get('config');
        $config = $config['smtp_service'];

        try {
            /**
             * @var $messageFooter EmailTemplate
             */
            $messageFooter = $this->serviceLocator->get('EmailFooterFactory');
            $messageFooter = $messageFooter->content;
            $messageHeader = $this->serviceLocator->get('EmailHeaderFactory');
            $messageHeader = $messageHeader->content;
        } catch (\Exception $e)
        {
            $messageFooter = '';
            $messageHeader = '';
        }

        $viewModel = new ViewModel();
        $viewModel->setTemplate('messaging/generic-message')
            ->setVariables([
                'messageBody' => $emailData->messageBody,
                'messageFooter' => $messageFooter,
                'messageHeader' => $messageHeader
            ]);

        $this->getMimeMessage()->addPart($this->getHtmlPart($viewModel));

        $mail = $this->getMailMessage();
        $mail->setFrom($config['default_from']);

        if (APPLICATION_ENVIRONMENT == 'production')
        {
            /**
             * @var $messageRecipient MessageRecipient
             */
            foreach ($emailData->messageRecipients as $messageRecipient)
            {
                if ($messageRecipient->enabled)
                {
                    $mail->addTo(sprintf("%s <%s>", $messageRecipient->name, $messageRecipient->email));
                }
            }
        } else
        {
            $mail->addTo($config['debug_from']);
        }
        if ($user)
        {
            $mail->addBcc($user->email);
        }
        $mail->setSubject($emailData->messageSubject);
        $mail->setBody($this->getMimeMessage());

        $this->dispatchMail();
    }
}
