<?php

namespace Application\Services;

class TemplateImageResizer {

    /**
     * @var $domDocument \DOMDocument
     */
    private $domDocument;
    private $template_data;
    private $potential_resize_issue = false;

    public function __construct($template_data)
    {
        $this->template_data = $template_data;
        $this->domDocument = new \DOMDocument();
        $this->domDocument->loadHTML($this->template_data);
    }

    public function potentialResizeIssue()
    {
        return $this->potential_resize_issue;
    }

    public function getRawTemplate()
    {
        return $this->template_data;
    }

    public function getParsedTemplate()
    {
        $this->resizeImages();
        $bodyDom = $this->domDocument->getElementsByTagName('body');
        $bodyDom = $bodyDom->item(0);
        $document = $this->domDocument->saveHTML($bodyDom);
        $document = preg_replace("/<body>/", "", $document);
        $document = preg_replace("/<\/body>/", "", $document);
        return $document;
    }

    protected function resizeImage(\DOMElement $imageElement)
    {
        $width = $imageElement->getAttribute('width');
        $height = $imageElement->getAttribute('height');
        $src = $imageElement->getAttribute('src');

        list ($control, $data) = preg_split('/,/', $src);

        $image_binary = base64_decode($data);

        $image_info = getimagesizefromstring($image_binary);

        if ($image_info[0] != $width || $image_info[1] != $height)
        {

            /**
             * If we are making an image 70% smaller, that could be a major problem with any text embedded on the image
             */
            if ($width / $image_info[0] < 0.3 || $height / $image_info[1] < 0.3)
            {
                $this->potential_resize_issue = true;
            }

            $gd_image = imagecreatefromstring($image_binary);
            $tmp_image = imagecreate($width, $height);
            imagecopyresampled($tmp_image, $gd_image, 0, 0, 0, 0,
                $width, $height, $image_info[0], $image_info[1]);

            $file_buffer = fopen(sys_get_temp_dir() . '/wstr_template_image', "w");

            switch ($image_info['mime'])
            {
                case 'image/png':
                    imagepng($tmp_image, $file_buffer);
                    break;
                case 'image/gif':
                    imagegif($tmp_image, $file_buffer);
                    break;
                case 'image/jpg':
                case 'image/jpeg':
                    imagejpeg($tmp_image, $file_buffer);
                    break;
                default:
                    throw new \Exception("Unknown image type " . $image_info['mime']);
            }
            $new_image_binary = file_get_contents(sys_get_temp_dir() . '/wstr_template_image');
            $new_base64 = base64_encode($new_image_binary);

            $imageElement->setAttribute('src', sprintf("data:%s;base64,%s",
                $image_info['mime'], $new_base64));
        }
    }

    protected function resizeImages()
    {
        $images = $this->domDocument->getElementsByTagName('img');

        for ($i = 0; $i < $images->length; $i++)
        {
            $this->resizeImage($images->item($i));
        }
    }
}