 /**
 * angular module - all we need to do is register the module(s), we can later add controllers,
 * directives, filters and services and register them with the module
 *
 * Be sure to inject any third-party required modules, or other modules that you've created
 */
(function($, angular, document, window)
{
    window.phillyByFoot = angular.module('phillyByFoot',
        ['ui.bootstrap','ngMessages', 'ngRoute', 'ngAria', 'chart.js', 'cgNotify',
            'ng-currency', 'toggle-switch', 'ui.sortable', 'ngSanitize', '720kb.datepicker','ui.tinymce'])
        .config(['$locationProvider', function($locationProvider)
        {
            $locationProvider.hashPrefix('');
        }]);

    /**
     * For some reason i can't add this to Array.prototype as it seems to blow up models
     */
    window.uniqueArray = function(array)
    {
        var a = array.concat();

        for(var i=0; i<a.length; ++i)
        {
            for(var j=i+1; j<a.length; ++j)
            {
                if(a[i] === a[j]) { a.splice(j--, 1); }
            }
        }

        return a;
    };

    /**
     * 3 minute keep alive, 15 minute inactivity auto-logout
     */
    var serverPing = function()
    {
        $.get("/wstr/application/login/ping", function(data)
        {
            if ((data.hasOwnProperty('s') && data.s === 0))
            {
                alert("You have been automatically logged out due to inactivity.");
                window.location.href = '/wstr/application/logout';
                return;
            }
            setTimeout(serverPing, 3000 * 60);
        });
    };
    setTimeout(serverPing, 3000 * 60);


    window.getVisibleText = function(element)
    {
        window.getSelection().removeAllRanges();

        var range = document.createRange();
        range.selectNode(element);
        window.getSelection().addRange(range);

        var visibleText = window.getSelection().toString().trim();
        window.getSelection().removeAllRanges();

        return visibleText;
    };

    Number.prototype.roundTo = function(digits)
    {
        if (digits === undefined)
        {
            digits = 0;
        }

        var m = Math.pow(10, digits);
        return Math.round(this * m) / m;
    };

    Date.prototype.nthDay = function(nth, weekday)
    {
        var days = ['sun','mon','tue','wed','thu','fri','sat'];
        var week = { 'first'  : 0, 'second' : 1, 'third'  : 2, 'fourth' : 3, 'fifth'  : 4, 'sixth'  : 5 };

        if (nth === 'last') { nth = this.getLastWeekWordInMonth(); }

        var firstDayOfMonth = new Date(this.getFullYear(), this.getMonth(), 1);
        var firstWeekday, newDate;

        firstWeekday = new Date(firstDayOfMonth.getFullYear(), firstDayOfMonth.getMonth(), firstDayOfMonth.getDate());

        while (days[firstWeekday.getDay()] !== weekday)
        {
            firstWeekday = new Date(firstWeekday.getFullYear(), firstWeekday.getMonth(), firstWeekday.getDate() + 1);
        }

        newDate = new Date(firstWeekday.getFullYear(), firstWeekday.getMonth(), firstWeekday.getDate());

        if (nth === 'first') { return newDate; }

        newDate = new Date(firstWeekday.getFullYear(), firstWeekday.getMonth(), (firstWeekday.getDate() + (week[nth] * 7)));

        /** in case of "last" "$day" in month, make sure we don't go outside the month **/
        while (newDate.getMonth() > this.getMonth())
        {
            newDate = new Date(newDate.getFullYear(), newDate.getMonth(), newDate.getDate() - 7);
        }

        return newDate;
    };

    Date.prototype.getWeeksInMonth = function()
    {

        var firstOfMonth = new Date(this.getFullYear(), this.getMonth(), 1);
        var lastOfMonth = new Date(this.getFullYear(), this.getMonth() + 1, 0);

        var used = firstOfMonth.getDay() + lastOfMonth.getDate();

        return Math.ceil( used / 7);
    };

    Date.prototype.getLastWeekWordInMonth = function()
    {
        var week = ['first','second','third','fourth','fifth','sixth'];
        return week[this.getWeeksInMonth() - 1];
    };

    Date.prototype.getWeekOfMonth = function()
    {
        var firstWeekday = new Date(this.getFullYear(), this.getMonth(), 1).getDay();
        var offsetDate = this.getDate() + firstWeekday - 1;
        return Math.floor(offsetDate / 7);
    };

    Date.prototype.weekOfMonthWord = function()
    {
        var week = ['first','second','third','fourth','fifth','sixth'];
        return week[this.getWeekOfMonth()];
    };

    Date.prototype.dayOfWeek = function()
    {
        var days = ['Sun','Mon','Tue','Wed','Thu','Fri','Sat'];
        return days[this.getDay()];
    };

    Date.prototype.dayOfWeekLong = function()
    {
        var days = ['Sunday','Monday','Tuesday','Wednesday','Thursday','Friday','Saturday'];
        return days[this.getDay()];
    };

    Date.prototype.getMonthName = function()
    {
        var months = ['Jan','Feb','Mar','Apr','May','Jun','Jul','Aug','Sep','Oct','Nov','Dec'];
        return months[this.getMonth()];
    };

    Date.prototype.addDays = function(days)
    {
        var date = new Date(this.valueOf());
        date.setDate(date.getDate() + days);
        return date;
    };

    Date.prototype.addMinutes = function(minutes)
    {
        var date = new Date(this.valueOf());
        date.setMinutes(date.getMinutes() + minutes);
        return date;
    };

    Date.prototype.getDateFull = function()
    {
        var day = this.getDate();

        return day <= 9 ? '0' + day : day;
    };

    Number.prototype.forceSign = function(multiplier)
    {
        var value = this;

        if (isNaN(value) || isNull(value)) { return value; }

        var decimal = Math.abs((value + "").split(".")[1]);
        var real    = Math.abs((value + "").split(".")[0]);
        multiplier /= 1;

        if (!isNaN(decimal) && !isNull(decimal))
        {
            return (real * multiplier) + (decimal * multiplier).toFixed(2)/1;
        } else
        {
            return (real * multiplier).toFixed(2)/1;
        }
    };

    window.isNull = function(value)
    {
        return ['',null,undefined].indexOf(value) !== -1;
    };

    $(window).scroll(function(eo)
    {
        var left = $(window).scrollLeft();
        $('.scroll-center').css({
            left : left + "px",
            position : 'relative'
        });
    });

})(jQuery, angular, document, window);
