(function($, angular, document, window)
{

    angular.module('phillyByFoot')
    .controller('AdminDayDetailsController', ['$q','$filter','$scope', '$http', '$window', '$location',
    'TaskTypesCollectionFactory', 'TourTypesCollectionFactory', 'UsersCollectionFactory',
    'TaskAssignmentCollectionFactory', 'GuideAssignmentCollectionFactory', 'GuideAvailabilityCollectionFactory',
    'GuideAssignmentFactory', 'ShiftsCollectionFactory', 'ShiftAssignmentsCollectionFactory',
    'GuideShiftAssignmentCollectionFactory', 'GuideShiftAssignmentFactory', 'CalendarFactory',
    'IntraControllerActionHandlerFactory', 'TaskAssignmentFactory', 'ReservedDateCollectionFactory',
    function($q, $filter, $scope, $http, $window, $location, TaskTypesCollection, TourTypesCollection,
             UsersCollection, TaskAssignmentCollection, GuideAssignmentCollection, GuideAvailabilityCollection,
             GuideAssignment, ShiftsCollection, ShiftAssignmentsCollection, GuideShiftAssignmentCollection,
             GuideShiftAssignment, Calendar, IntraControllerActionHandler, TaskAssignment, ReservedDateCollection)
    {

        window.scrollTo(0,0);

        if (!IntraControllerActionHandler.date)
        {
            IntraControllerActionHandler.date = new Date();
            IntraControllerActionHandler.date.setHours(0);
            IntraControllerActionHandler.date.setMinutes(0);
            IntraControllerActionHandler.date.setSeconds(0);
            IntraControllerActionHandler.date.setMilliseconds(0);
        }

        $scope.taskTypesCollection = TaskTypesCollection;
        $scope.tourTypesCollection = TourTypesCollection;
        $scope.usersCollection = UsersCollection;
        $scope.taskAssignmentCollection = TaskAssignmentCollection;
        $scope.guideAssignmentCollection = GuideAssignmentCollection;
        $scope.guideAvailabilityCollection = GuideAvailabilityCollection;
        $scope.shiftsCollection = ShiftsCollection;
        $scope.shiftAssignmentsCollection = ShiftAssignmentsCollection;
        $scope.guideShiftAssignmentCollection = GuideShiftAssignmentCollection;
        $scope.reservedDateCollection = ReservedDateCollection;

        $scope.reservedDateCollection.empty();
        $scope.taskAssignmentCollection.empty();
        $scope.guideAssignmentCollection.empty();
        $scope.guideAvailabilityCollection.empty();
        $scope.calendar = Calendar;

        $scope.isSaving = false;
        $scope.activeDay = null;
        $scope.filteredUsers = [];
        $scope.changesActive = false;
        $scope.showUnavailableGuides = false;
        $scope.guideShiftAssignment = {};
        var tableColumnCells = {};
        var timeAvailabilityList = {};
        var activeCellBlock = null;
        $scope.dayTimes = [];
        $scope.dayLoaded = false;

        $scope.orgEnabled = {
            constitutional : true,
            spirits : false
        };

        $scope.updateDate = function()
        {
            if (Calendar.selectedDate.getMonth() > $scope.activeDay.getMonth())
            {
                Calendar.prevMonth();
            } else if (Calendar.selectedDate.getMonth() < $scope.activeDay.getMonth())
            {
                Calendar.nextMonth();
            }
            $scope.loadDayDetails($scope.activeDay);
        };

        $scope.prevDay = function()
        {
            $scope.activeDay = $scope.activeDay.addDays(-1);
            $scope.updateDate();
        };

        $scope.nextDay = function()
        {
            $scope.activeDay = $scope.activeDay.addDays(+1);
            $scope.updateDate();
        };

        $scope.toggleOrganizations = function(which)
        {
            if (!which) { return; }

            if (which === 'spirits')
            {
                $scope.orgEnabled.constitutional = !$scope.orgEnabled.constitutional;
            } else
            {
                $scope.orgEnabled.spirits = !$scope.orgEnabled.spirits;
            }
            $scope.loadDayDetails($scope.activeDay);
            $scope.filteredUsers = [];
        };

        $scope.getFilteredUsers = function()
        {
            if ($scope.filteredUsers.length)
            {
                return $scope.filteredUsers;
            }
            $scope.filteredUsers = $scope.usersCollection.users.filter(function(user)
            {
                if ($scope.orgEnabled.constitutional && !user.organization_constitutional) { return false; }
                if ($scope.orgEnabled.spirits && !user.organization_spirits) { return false; }

                return user.status && !user.is_admin;
            });
            return $scope.filteredUsers;
        };

        $scope.getGuideAssignments = function(taskAssignment)
        {
            return $scope.guideAssignmentCollection.collection.filter(function(guideAssignment)
            {
                return guideAssignment.taskassignment_id/1 === taskAssignment.id/1;
            });
        };

        $scope.getGuide = function(userId)
        {
            return ($scope.usersCollection.users.filter(function(user)
            {
                return user.id/1 === userId/1;
            })).pop();
        };

        $scope.getAllGuideAssignments = function(user)
        {
            return $scope.guideAssignmentCollection.collection.filter(function(guideAssignment)
            {
                return guideAssignment.guide_id/1 === user.id/1;
            });
        };

        $scope.getGuideAssignment = function(user, taskAssignment)
        {
            var guideAssignment = ($scope.guideAssignmentCollection.collection.filter(function (guideAssignment)
            {
                return guideAssignment.taskassignment_id / 1 === taskAssignment.id / 1 &&
                       guideAssignment.guide_id / 1 === user.id / 1;
            })).pop();

            if (!guideAssignment)
            {
                guideAssignment = new GuideAssignment();
                guideAssignment.taskassignment_id = taskAssignment.id / 1;
                guideAssignment.guide_id = user.id / 1;
                guideAssignment.status = false;
                $scope.guideAssignmentCollection.collection.push(guideAssignment);
            }

            return guideAssignment;
        };

        $scope.getRemainingGuidesRequired = function(taskAssignment)
        {
            if (!taskAssignment) { return null; }
            return taskAssignment.numguidesrequired - ($scope.getGuideAssignmentsByTaskId(taskAssignment.id).length);
        };

        $scope.getGuideAssignmentsByTaskId = function(id)
        {
            return $scope.guideAssignmentCollection.collection.filter(function (assignment)
            {
                return assignment.taskassignment_id / 1 === id / 1 && assignment.status;
            });
        };

        $scope.allTasksAssigned = function(day)
        {
            var tasks = $scope.taskAssignmentCollection.collection.filter(function (taskAssignment)
            {
                if ($scope.orgEnabled.constitutional && taskAssignment.organization_id / 1 !== 1) { return false; }
                if ($scope.orgEnabled.spirits && taskAssignment.orgEnabled / 1 !== 2) { return false; }

                if (taskAssignment.tasktype/1 !== 1 && taskAssignment.tasktype/1 !== 12) { return false; }
                if (taskAssignment.tasktype/1 === 1 && taskAssignment.tourtype/1 === 1)  { return false; }

                var taskDate = new Date(taskAssignment.assignmentdate + ' 00:00:00');

                if (taskDate.getTime() !== day.getTime()) { return false; }
                var guideAssignments = $scope.getGuideAssignmentsByTaskId(taskAssignment.id);
                return guideAssignments.length <= 0 || taskAssignment.numguidesrequired > guideAssignments.length;

            });

            return tasks.length <= 0;
        };

        $scope.getUnassignedTaskAssignment = function(time)
        {
            var tasks = $scope.taskAssignmentCollection.collection.filter(function (taskAssignment)
            {
                if ($scope.orgEnabled.constitutional && taskAssignment.organization_id / 1 !== 1) { return false; }
                if ($scope.orgEnabled.spirits && taskAssignment.orgEnabled / 1 !== 2) { return false; }

                if (taskAssignment.tasktype/1 !== 1 && taskAssignment.tasktype/1 !== 12) { return false; }
                if (taskAssignment.tasktype/1 === 1 && taskAssignment.tourtype/1 === 1)  { return false; }
                if (!(time >= taskAssignment.starttime && time < taskAssignment.endtime)) { return false; }

                var guideAssignments = $scope.getGuideAssignmentsByTaskId(taskAssignment.id);
                return guideAssignments.length <= 0 || taskAssignment.numguidesrequired > guideAssignments.length;
            });


            return tasks.pop();
        };

        $scope.getGuideAssignmentByTime = function(time, user)
        {
            var taskAssignments = $scope.taskAssignmentCollection.collection.filter(function(taskAssignment)
            {
                return (time >= taskAssignment.starttime && time < taskAssignment.endtime);
            });


            var guideAssignments = $scope.guideAssignmentCollection.collection.filter(function(guideAssignment)
            {
                if (guideAssignment.guide_id/1 !== user.id/1) { return false; }
                if (!guideAssignment.status) { return false; }

                var isInTaskList = false;
                taskAssignments.forEach(function(taskAssignment)
                {
                    if (taskAssignment.id/1 === guideAssignment.taskassignment_id/1) { isInTaskList = true; }
                });

                return isInTaskList;
            });

            return guideAssignments.pop();
        };

        $scope.getTaskType = function(taskAssignment)
        {
            return ($scope.taskTypesCollection.taskTypes.filter(function (taskType)
            {
                return taskAssignment.tasktype / 1 === taskType.id;
            })).pop();
        };

        $scope.getTourType = function(taskAssignment)
        {
            return ($scope.tourTypesCollection.tourTypes.filter(function(tourType)
            {
                return tourType.id/1 === taskAssignment.tourtype/1;
            })).pop();
        };

        $scope.getAvailability = function(user, day)
        {
            return $scope.guideAvailabilityCollection.availabilities.filter(function(guideAvailability)
            {
                if (guideAvailability.guide_id/1 !== user.id/1) { return false; }

                var availabilityDate = new Date(guideAvailability.availabilitydate + ' 00:00:00');

                return availabilityDate <= day && day <= availabilityDate;
            });
        };

        $scope.executeCellEditAction = function(time, objRef, key)
        {
            var newCellBlock = $scope.getCellBlock(time, key);

            if (newCellBlock.availability === 'unavailable') { return; }

            /**
             * Deactivate selected block
             */
            if (activeCellBlock !== null && activeCellBlock === newCellBlock)
            {
                activeCellBlock = null;
                newCellBlock.active = false;
                return;
            }

            /**
             * Activate clicked block
             */
            if (activeCellBlock === null && newCellBlock.taskAssignment !== null)
            {
                activeCellBlock = newCellBlock;
                newCellBlock.active = true;
                return;
            }

            /**
             * No action, nothing here to work on
             */
            if (activeCellBlock === null && newCellBlock.taskAssignment === null)
            {
                return;
            }

            /**
             * Just changing from one start target to another start target
             */
            if (activeCellBlock !== null && newCellBlock.taskAssignment !== null)
            {
                activeCellBlock.active = false;
                activeCellBlock = newCellBlock;
                newCellBlock.active = true;
                return;
            }

            var updateTaskTime = false;

            if (confirm('Do you wish to change the selected task assignment?'))
            {
                var taskAssignment = activeCellBlock.taskAssignment;
                var startTime, endTime, difference, promises;
                var oldUser = null;

                if (activeCellBlock.blockStart.getTime() !== newCellBlock.blockStart.getTime())
                {
                    var targetTime = $filter('date')(newCellBlock.blockStart, 'h:mm a');
                    var taskTime = $filter('date')(activeCellBlock.blockStart, 'h:mm a');

                    if (confirm(
                        "Warning: the target time (" + targetTime + ") is not the same as the assigned " +
                        "task's start time ("+ taskTime +"). Do you wish to update the task\'s start time as well?"
                    )){
                        updateTaskTime = true;
                        startTime = taskAssignment.starttime;
                        endTime = taskAssignment.endtime;

                        difference = endTime - startTime;

                        startTime = new Date(newCellBlock.blockStart);
                        endTime   = newCellBlock.blockStart.addMinutes(difference/1000/60);
                    }
                }

                /**
                 * Move/Unassign a task - drop location is the Unassigned Tasks column
                 * We can move from this column to the same column to simply update a task start time
                 * or we can move from a user column to this column to unassign the task and potentially
                 * update the task's start/end time
                 */
                if (!objRef.hasOwnProperty('type'))
                {
                    if (updateTaskTime)
                    {
                        /**
                         * If there are linked guide assignments, make sure that every guide assigned is
                         * available for the new task time.
                         */
                        if (taskAssignment.numguidesrequired > 1 && updateTaskTime)
                        {
                            if (!$scope.linkedGuidesAvailable(taskAssignment, startTime, endTime, activeCellBlock.objectRef))
                            {
                                alert('Guides linked to this task are not available for the duration of the newly selected task duration.');
                                return;
                            }
                        }
                        taskAssignment.starttime = startTime;
                        taskAssignment.endtime = endTime;
                    }

                    activeCellBlock.working = true;
                    newCellBlock.working = true;

                    promises = [];

                    promises.push(taskAssignment.save());

                    if (activeCellBlock.objectRef.hasOwnProperty('type') && activeCellBlock.objectRef.type === 'User')
                    {
                        oldUser = activeCellBlock.objectRef;
                        promises = $scope.removeAssignedGuide(taskAssignment, oldUser);
                    }

                    $q.all(promises).then(function()
                    {
                        if (oldUser)
                        {
                            $scope.loadTableColumnCells(oldUser, oldUser.name, true);
                        }

                        $scope.loadTableColumnCells({}, 'Unassigned Tasks', true);

                        if (taskAssignment.numguidesrequired > 1 && updateTaskTime)
                        {
                            $scope.updateLinkedTaskCells(taskAssignment, null);
                        }
                    });
                }

                /**
                 * Move/Assign a task to a user
                 * The task to assign could come from the unassigned tasks column or from the
                 * shifts column
                 */
                if (objRef.hasOwnProperty('type') && objRef.type === 'User')
                {
                    var newUser = objRef;

                    /**
                     * update the task time after seeing if the guide is available for the new task's duration
                     */
                    if (updateTaskTime)
                    {
                        if (!$scope.isGuideAvailableByTime(startTime, newUser) ||
                            !$scope.isGuideAvailableByTime(endTime.addMinutes(-15), newUser))
                        {
                            alert('Guide is not available for the duration of the selected task.');
                            return;
                        }

                        /**
                         * If there are linked guide assignments, make sure that every guide assigned is
                         * available for the new task time.
                         */
                        if (taskAssignment.numguidesrequired > 1 && updateTaskTime)
                        {
                            if (!$scope.linkedGuidesAvailable(taskAssignment, startTime, endTime, activeCellBlock.objectRef))
                            {
                                alert('Guides linked to this task are not available for the duration of the newly selected task duration.');
                                return;
                            }
                        }

                        taskAssignment.starttime = startTime;
                        taskAssignment.endtime = endTime;
                    }

                    /**
                     * if we haven't updated the task time, we still need to check to see if the guide
                     * is available during the task's duration
                     */
                    if (!$scope.isGuideAvailableByTime(taskAssignment.starttime, newUser) ||
                        !$scope.isGuideAvailableByTime(taskAssignment.endtime.addMinutes(-15), newUser))
                    {
                        alert('Guide is not available for the duration of the selected task.');
                        return;
                    }

                    promises = [];

                    promises.push(taskAssignment.save());

                    activeCellBlock.working = true;
                    newCellBlock.working = true;

                    if (activeCellBlock.objectRef.hasOwnProperty('type') && activeCellBlock.objectRef.type === 'User')
                    {
                        oldUser = activeCellBlock.objectRef;
                        promises = $scope.removeAssignedGuide(taskAssignment, oldUser);
                    }

                    var guideAssignment = $scope.getGuideAssignment(newUser, taskAssignment);
                    guideAssignment.status = true;
                    promises.push(guideAssignment.save());

                    $q.all(promises).then(function()
                    {
                        if (oldUser)
                        {
                            $scope.loadTableColumnCells(oldUser, oldUser.name, true);
                        }

                        $scope.loadTableColumnCells({}, 'Unassigned Tasks', true);
                        $scope.loadTableColumnCells(newUser, newUser.name, true);

                        if (taskAssignment.numguidesrequired > 1 && updateTaskTime)
                        {
                            $scope.updateLinkedTaskCells(taskAssignment, newUser);
                        }
                    });
                }

                activeCellBlock.active = false;
                activeCellBlock = null;
            }

        };

        $scope.linkedGuidesAvailable = function(taskAssignment, startTime, endTime, objRef)
        {
            var allGuidesAvailable = true;

            $scope.getGuideAssignmentsByTaskId(taskAssignment.id).forEach(function(guideAssignment)
            {
                var guide = $scope.getGuide(guideAssignment.guide_id);

                /**
                 * Don't test against the user we're moving a task away from
                 */
                if (objRef && objRef.hasOwnProperty('type') && objRef.type === 'User')
                {
                    if (objRef.id/1 === guide.id/1) { return; }
                }

                if (!$scope.isGuideAvailableByTime(startTime, guide) ||
                    !$scope.isGuideAvailableByTime(endTime.addMinutes(-15), guide))
                {
                    allGuidesAvailable = false;
                }
            });

            return allGuidesAvailable;
        };

        $scope.updateLinkedTaskCells = function(taskAssignment, skipUser)
        {
            var guideAssignments = $scope.getGuideAssignmentsByTaskId(taskAssignment.id);
            guideAssignments.forEach(function(guideAssignment)
            {
                var guide = $scope.getGuide(guideAssignment.guide_id);
                if (skipUser && skipUser.id/1 !== guide.id/1)
                {
                    $scope.loadTableColumnCells(guide, guide.name, true);
                } else
                {
                    $scope.loadTableColumnCells(guide, guide.name, true);
                }
            });
        };

        $scope.removeAssignedGuide = function(taskAssignment, user)
        {
            var promises = [];

            $scope.getGuideAssignments(taskAssignment).forEach(function(guideAssignment)
            {
                if (guideAssignment.guide_id/1 === user.id/1 &&
                    taskAssignment.id/1 === guideAssignment.taskassignment_id/1
                ){
                    guideAssignment.status = false;
                    promises.push(guideAssignment.save());
                }
            });

            return promises;
        };

        $scope.unassignGuide = function(cellBlock, user, $event)
        {
            if (confirm("Are you sure you wish to un-assign this task?"))
            {
                var taskAssignment = cellBlock.taskAssignment;
                cellBlock.working = true;
                $q.all($scope.removeAssignedGuide(taskAssignment, user)).then(function()
                {
                    $scope.loadTableColumnCells(user, user.name, true);
                    $scope.loadTableColumnCells({}, 'Unassigned Tasks', true);
                });
            }

            if ($event)
            {
                if ($event.stopPropagation) { $event.stopPropagation(); }
                if ($event.preventDefault)  { $event.preventDefault();  }
                $event.cancelBubble = true;
                $event.returnValue = false;
            }
        };

        $scope.shouldShowCell = function(time, key)
        {
            if (!tableColumnCells[key]) { return false; }
            if (!tableColumnCells[key][time.getTime()]) { return false; }

            var cellBlock = $scope.getCellBlock(time, key);

            return (cellBlock.blockStart.getTime() === time.getTime() || cellBlock.availability === 'available');
        };

        $scope.getCellBlock = function(time, key)
        {
            if (!tableColumnCells[key]) { return null; }
            if (!tableColumnCells[key][time.getTime()]) { return null; }

            return tableColumnCells[key][time.getTime()];
        };

        $scope.loadTableColumnCells = function(objectRef, key, reload)
        {
            if (!tableColumnCells[key] || reload)
            {
                tableColumnCells[key] = {};
            }

            var dayTime = $scope.dayTimes[0];
            var oldTaskAssignment;
            var availabilityList = objectRef.hasOwnProperty('type') && objectRef.type === 'User' ?
                                   $scope.getGuideAvailabilitiesByTime(dayTime, objectRef) : [];
            var guideAssignment = objectRef.hasOwnProperty('type') && objectRef.type === 'User' ?
                                  $scope.getGuideAssignmentByTime(dayTime, objectRef) : null;

            var taskAssignment = guideAssignment ? $scope.getTaskAssignmentById(guideAssignment.taskassignment_id) : null;
            oldTaskAssignment = taskAssignment;

            if (objectRef.hasOwnProperty('type') && objectRef.type === 'ShiftAssignment')
            {
                taskAssignment = $scope.getTaskAssignmentByShift(objectRef, dayTime);
                oldTaskAssignment = taskAssignment;
            }

            if (key === 'Unassigned Tasks')
            {
                taskAssignment = $scope.getUnassignedTaskAssignment(dayTime);
                oldTaskAssignment = taskAssignment;
            }

            var taskType = taskAssignment ? $scope.getTaskType(taskAssignment) : null;
            var tourType = taskAssignment ? $scope.getTourType(taskAssignment) : null;

            var availability = 'available';

            if (objectRef.hasOwnProperty('type') && objectRef.type === 'User')
            {
                availability = guideAssignment ? 'assignment' : availability;
                availability = availabilityList.length <= 0 ? 'unavailable' : availability;
            } else if (objectRef.hasOwnProperty('type') && objectRef.type === 'ShiftAssignment')
            {
                availability = taskAssignment ? 'assignment' : availability;
            } else if (key === 'Unassigned Tasks')
            {
                availability = taskAssignment ? 'assignment' : availability;
            }

            var availabilityCell = {
                blockStart : dayTime,
                blockEnd : dayTime,
                availability : availability,
                guideAssignment : guideAssignment,
                taskAssignment : taskAssignment,
                objectRef : objectRef,
                taskType : taskType,
                tourType : tourType,
                rowCount : 1
            };

            tableColumnCells[key][dayTime.getTime()] = availabilityCell;

            var i=1;

            do {

                dayTime = $scope.dayTimes[i];

                availabilityList = objectRef.hasOwnProperty('type') && objectRef.type === 'User' ?
                                   $scope.getGuideAvailabilitiesByTime(dayTime, objectRef) : [];

                guideAssignment = objectRef.hasOwnProperty('type') && objectRef.type === 'User' ?
                                  $scope.getGuideAssignmentByTime(dayTime, objectRef) : null;

                taskAssignment = guideAssignment ? $scope.getTaskAssignmentById(guideAssignment.taskassignment_id) : null;


                if (objectRef.hasOwnProperty('type') && objectRef.type === 'ShiftAssignment')
                {
                    taskAssignment = $scope.getTaskAssignmentByShift(objectRef, dayTime);
                }

                if (key === 'Unassigned Tasks')
                {
                    taskAssignment = $scope.getUnassignedTaskAssignment(dayTime);
                }


                taskType = taskAssignment ? $scope.getTaskType(taskAssignment) : null;
                tourType = taskAssignment ? $scope.getTourType(taskAssignment) : null;

                var currentAvailability = 'available';

                if (objectRef.hasOwnProperty('type') && objectRef.type === 'User')
                {
                    currentAvailability = guideAssignment ? 'assignment' : currentAvailability;
                    currentAvailability = availabilityList.length <= 0 ? 'unavailable' : currentAvailability;
                } else if (objectRef.hasOwnProperty('type') && objectRef.type === 'ShiftAssignment')
                {
                    currentAvailability = taskAssignment ? 'assignment' : currentAvailability;
                } else if (key === 'Unassigned Tasks')
                {
                    currentAvailability = taskAssignment ? 'assignment' : currentAvailability;
                }

                if (currentAvailability === 'available')
                {
                    availabilityCell = {
                        blockStart : dayTime,
                        blockEnd : dayTime,
                        objectRef : objectRef,
                        availability : null,
                        guideAssignment : null,
                        taskAssignment : null,
                        taskType : null,
                        tourType : null,
                        rowCount : 0
                    };
                }

                if (oldTaskAssignment !== taskAssignment || availabilityCell.availability !== currentAvailability)
                {
                    availabilityCell = {
                        blockStart : dayTime,
                        blockEnd : dayTime,
                        objectRef : objectRef,
                        availability : null,
                        guideAssignment : null,
                        taskAssignment : null,
                        taskType : null,
                        tourType : null,
                        rowCount : 0
                    };
                }

                oldTaskAssignment = taskAssignment;

                availabilityCell.tourType = tourType;
                availabilityCell.taskAssignment = taskAssignment;
                availabilityCell.taskType = taskType;
                availabilityCell.guideAssignment = guideAssignment;
                availabilityCell.availability = currentAvailability;
                availabilityCell.blockEnd = dayTime;
                availabilityCell.rowCount++;

                if (availabilityCell.availability === 'available')
                {
                    availabilityCell.rowCount = 1;
                }

                if (!tableColumnCells[key][dayTime.getTime()])
                {
                    tableColumnCells[key][dayTime.getTime()] = availabilityCell;
                }

                i++;

            } while (i < $scope.dayTimes.length);

        };

        $scope.getGuideAvailabilitiesByTime = function(time, user)
        {
            if (!timeAvailabilityList[user.id])
            {
                timeAvailabilityList[user.id] = [];
                timeAvailabilityList[user.id][time.getTime()] = null;
            }

            if (timeAvailabilityList[user.id][time.getTime()])
            {
                return timeAvailabilityList[user.id][time.getTime()];
            }

            var guideAvailabilities = $scope.guideAvailabilityCollection.availabilities.filter(function(guideAvailability)
            {
                if (guideAvailability.guide_id/1 !== user.id/1) { return false; }

                var availabilityStart = guideAvailability.starttime;
                var availabilityEnd = guideAvailability.endtime;

                return availabilityStart <= time && time < availabilityEnd;
            });

            timeAvailabilityList[user.id][time.getTime()] = guideAvailabilities;

            return guideAvailabilities;
        };

        $scope.isGuideAvailableByTime = function(time, user)
        {
            return $scope.getGuideAvailabilitiesByTime(time, user).length > 0;
        };

        $scope.isGuideAvailable = function(user, day)
        {
            return $scope.getAvailability(user,day).length > 0;
        };

        $scope.getTaskAssignmentById = function(taskAssignmentId, day)
        {
            return ($scope.taskAssignmentCollection.collection.filter(function(taskAssignment)
            {
                if (day && (new Date(taskAssignment.assignmentdate + ' 00:00:00')).getTime() !== day.getTime())
                {
                    return false;
                }
                return taskAssignment.id/1 === taskAssignmentId/1;
            })).pop();
        };

        $scope.getTaskAssignmentByShift = function (shiftAssignment, time)
        {
            return ($scope.taskAssignmentCollection.collection.filter(function(taskAssignment)
            {
                return taskAssignment.shiftassignment_id/1 === shiftAssignment.id/1 &&
                       (time >= taskAssignment.starttime && time < taskAssignment.endtime);
            })).pop();
        };

        $scope.addNewTour = function(day)
        {
            IntraControllerActionHandler.action = 'new-task';
            IntraControllerActionHandler.model = new TaskAssignment();
            IntraControllerActionHandler.model.organization_id = $scope.orgEnabled.constitutional ? 1 : 2;
            IntraControllerActionHandler.model.assignmentdate = $filter('date')(day, 'MMM dd, yyyy');
            IntraControllerActionHandler.model.numguidesrequired = 0;
            IntraControllerActionHandler.model.numpersonsontour = 0;
            IntraControllerActionHandler.model.tourtype = 0;
            IntraControllerActionHandler.model.paymentstatus = '0';
            IntraControllerActionHandler.date = day;
            IntraControllerActionHandler.stopEvents = false;
            IntraControllerActionHandler.returnPath = '/admin/day-details';
            IntraControllerActionHandler.priorModel = null;
            IntraControllerActionHandler.priorAction = 'open-day-details';
            IntraControllerActionHandler.priorDate = day;
            IntraControllerActionHandler.priorReturnPath = '/admin/day-details';

            $location.path('/admin/edit-task');

        };

        $scope.deleteAssignment = function(taskAssignment, $event)
        {
            if (confirm("Are you sure you wish to delete this Task?"))
            {
                $scope.isSaving = true;
                $scope.changesActive = false;
                $scope.taskAssignmentCollection.deleteEntry(taskAssignment).then(function()
                {
                    $scope.isSaving = false;
                    $scope.reloadTableData();
                });
            }

            if ($event)
            {
                if ($event.stopPropagation) { $event.stopPropagation(); }
                if ($event.preventDefault)  { $event.preventDefault();  }
                $event.cancelBubble = true;
                $event.returnValue = false;
            }
        };

        $scope.openTourDetails = function(taskAssignment, day)
        {
            IntraControllerActionHandler.action = 'edit-task';
            IntraControllerActionHandler.model = taskAssignment;
            IntraControllerActionHandler.date = day;
            IntraControllerActionHandler.stopEvents = false;
            IntraControllerActionHandler.returnPath = '/admin/day-details';
            IntraControllerActionHandler.priorModel = null;
            IntraControllerActionHandler.priorAction = 'open-day-details';
            IntraControllerActionHandler.priorDate = day;
            IntraControllerActionHandler.priorReturnPath = '/admin/day-details';

            $location.path('/admin/edit-task');

        };

        $scope.loadDayDetails = function(day)
        {
            $scope.isSaving = true;
            $scope.filteredUsers = [];
            $scope.guideShiftAssignment = {};
            tableColumnCells = {};
            timeAvailabilityList = {};
            activeCellBlock = null;
            $scope.dayTimes = [];
            $scope.dayLoaded = false;

            var startTime = new Date(day);
            startTime.setHours(8);
            startTime.setMinutes(0);

            var endTime = new Date(day);
            endTime.setHours(23);
            endTime.setMinutes(0);

            while (startTime < endTime)
            {
                $scope.dayTimes.push(startTime);
                startTime = startTime.addMinutes(15);
            }

            $scope.reservedDateCollection.reload(day, day);

            $scope.taskAssignmentCollection.reload(day, day).then(function()
            {
                var organization_id = $scope.orgEnabled.constitutional ? 1 : 2;
                var promises = [];

                var taskAssignments = $scope.taskAssignmentCollection.getTaskAssignments(day, organization_id);

                var shiftAssignmentIds = taskAssignments.map(function(taskAssignment)
                {
                    return taskAssignment.shiftassignment_id;
                }).filter(function(shiftId, index, self)
                {
                    return self.indexOf(shiftId) === index && shiftId !== null;
                });

                promises.push($scope.guideAssignmentCollection.reload($scope.taskAssignmentCollection.collection));
                promises.push($scope.shiftAssignmentsCollection.reload(null, shiftAssignmentIds));
                promises.push($scope.guideShiftAssignmentCollection.reload(shiftAssignmentIds));
                promises.push($scope.guideAvailabilityCollection.reload(null, day, day));

                $q.all(promises).then(function()
                {
                    $scope.reloadTableData();
                    $scope.dayLoaded = true;
                    $scope.isSaving = false;
                });

            });
        };

        $scope.reloadTableData = function()
        {
            $scope.loadTableColumnCells({}, 'Unassigned Tasks', true);

            $scope.getFilteredUsers().forEach(function(user)
            {
                $scope.loadTableColumnCells(user, user.name, true);
            });

            $scope.guideShiftAssignment = {};

            $scope.shiftAssignmentsCollection.assignments.forEach(function(shiftAssignment)
            {
                $scope.getGuideShiftAssignment(shiftAssignment);
                $scope.loadTableColumnCells(shiftAssignment, shiftAssignment.getKey(), true);
            });
        };

        $scope.isReserved = function(user, day)
        {
            var org_id = $scope.orgEnabled.spirits ? 2 : 1;

            var reserved = $scope.reservedDateCollection.collection.filter(function(reservedDate)
            {
                var reserved_date = new Date(reservedDate.reserveddate + ' 00:00:00');
                return (day.getTime() === reserved_date.getTime() && reservedDate.reserved &&
                    user.id/1 === reservedDate.guide_id/1 && org_id === reservedDate.organization_id/1);
            });

            return reserved.length > 0;
        };

        $scope.deleteShiftAssignment = function(shiftAssignment)
        {
            if (confirm("Are you sure you wish to delete this item?"))
            {
                $scope.guideShiftAssignment[shiftAssignment.id].guide_id = 0;
                $scope.addGuideToShift(shiftAssignment, $scope.guideShiftAssignment[shiftAssignment.id]);
            }
        };

        $scope.getGuideShiftAssignment = function(shiftAssignment)
        {
            if ($scope.guideShiftAssignment[shiftAssignment.id])
            {
                return $scope.guideShiftAssignment[shiftAssignment.id];
            }

            var guideShiftAssignments = $scope.guideShiftAssignmentCollection.collection.filter(function(guideShiftAssignment)
            {
                var shiftAssignmentDate = new Date(guideShiftAssignment.assignmentdate + ' 00:00:00');
                if (shiftAssignmentDate.getTime() !== $scope.activeDay.getTime())
                {
                    return false;
                }
                return shiftAssignment.id / 1 === guideShiftAssignment.shiftassignment_id / 1;
            });

            if (guideShiftAssignments.length <= 0)
            {
                $scope.guideShiftAssignment[shiftAssignment.id] = new GuideShiftAssignment();
                $scope.guideShiftAssignment[shiftAssignment.id].shiftassignment_id = shiftAssignment.id;
                $scope.guideShiftAssignment[shiftAssignment.id].assignmentdate = $filter('date')($scope.activeDay, 'yyyy-MM-dd');
            } else
            {
                $scope.guideShiftAssignment[shiftAssignment.id] = guideShiftAssignments.pop();
            }

            return $scope.guideShiftAssignment[shiftAssignment.id];
        };

        $scope.getShiftTimes = function(shiftAssignment)
        {
            var shiftTaskAssignments = $scope.taskAssignmentCollection.collection.filter(function(taskAssignment)
            {
                var taskAssignmentDate = new Date(taskAssignment.assignmentdate + ' 00:00:00');

                if (taskAssignmentDate.getTime() !== $scope.activeDay.getTime()) { return false; }
                return taskAssignment.shiftassignment_id/1 === shiftAssignment.id/1;
            });

            var shiftStart, shiftEnd;

            shiftTaskAssignments.forEach(function(taskAssignment)
            {
                if (!shiftStart || shiftStart > taskAssignment.starttime) { shiftStart = taskAssignment.starttime; }
                if (!shiftEnd   || shiftEnd   < taskAssignment.endtime)   { shiftEnd   = taskAssignment.endtime;   }
            });

            return {
                shiftStart : shiftStart,
                shiftEnd : shiftEnd
            };
        };

        $scope.getAvailableUsersForShift = function(shiftAssignment)
        {
            var shiftStartEnd = $scope.getShiftTimes(shiftAssignment);

            var shiftStart = shiftStartEnd.shiftStart;
            var shiftEnd   = shiftStartEnd.shiftEnd;


            var selectedGuideId = $scope.getGuideShiftAssignment(shiftAssignment);
            selectedGuideId = selectedGuideId.hasOwnProperty('guide_id') ? selectedGuideId.guide_id/1 : 0;

            var usersList = $scope.getFilteredUsers().filter(function(user)
            {
                if (selectedGuideId && selectedGuideId === user.id/1) { return true; }

                /**
                 * if a user has an assignment during a task in this shift, remove them
                 * from the list of users
                 */
                var guideHasAssignment = false;

                $scope.getAllGuideAssignments(user).forEach(function(guideAssignment)
                {
                    if (!guideAssignment.status) { return; }
                    if (guideHasAssignment) { return; }

                    var taskAssignment = $scope.getTaskAssignmentById(guideAssignment.taskassignment_id, $scope.activeDay);

                    if (taskAssignment)
                    {
                        /**
                         * The task assignment for the guide is within the same time as the shift assignment
                         */
                        if (taskAssignment.endtime > shiftStart || (taskAssignment.starttime < shiftEnd  && taskAssignment.starttime >= shiftStart))
                        {
                            guideHasAssignment = true;
                        }
                    }
                });

                /**
                 * find the availability of the user, to make sure they're available during the requested timeframe
                 */
                var guideStart, guideEnd;

                $scope.getAvailability(user, $scope.activeDay).forEach(function(guideAvailability)
                {
                    if (!guideStart || guideStart > guideAvailability.starttime) { guideStart = guideAvailability.starttime; }
                    if (!guideEnd   || guideEnd   < guideAvailability.endtime)   { guideEnd   = guideAvailability.endtime;   }
                });

                return (guideStart <= shiftStart && guideEnd >= shiftEnd) && !guideHasAssignment;
            });

            return usersList;
        };

        $scope.addGuideToShift = function(shiftAssignment, guideShiftAssignment)
        {
            var promises = [];

            /**
             * First, save the guide shift assignment
             */
            promises.push(guideShiftAssignment.save());

            var guideShiftAssignmentDate = new Date(guideShiftAssignment.assignmentdate + ' 00:00:00');

            var guide;

            if (guideShiftAssignment.guide_id && guideShiftAssignment.guide_id/1 > 0)
            {
                guide = $scope.getGuide(guideShiftAssignment.guide_id);
            }
            var removedGuides = [];

            $scope.taskAssignmentCollection.collection.forEach(function(taskAssignment)
            {
                if (taskAssignment.shiftassignment_id/1 !== shiftAssignment.id/1) { return; }
                var assignmentDate = new Date(taskAssignment.assignmentdate + ' 00:00:00');

                if (assignmentDate.getTime() !== guideShiftAssignmentDate.getTime()) { return; }

                /**
                 * Remove all existing assignments for the tasks in this shift
                 */
                $scope.getGuideAssignments(taskAssignment).forEach(function(guideAssignment)
                {
                    if (guide && guideAssignment.guide_id/1 === guide.id/1) { return; }

                    if (taskAssignment.id/1 === guideAssignment.taskassignment_id/1 && guideAssignment.status)
                    {
                        removedGuides.push($scope.getGuide(guideAssignment.guide_id));
                        guideAssignment.status = false;
                        promises.push(guideAssignment.save());
                    }
                });

                if (guide)
                {
                    /**
                     * Assign the new guide to each task in this shift
                     */
                    var guideAssignment = $scope.getGuideAssignment(guide, taskAssignment);
                    guideAssignment.status = true;
                    promises.push(guideAssignment.save());
                }
            });

            $q.all(promises).then(function()
            {
                removedGuides.forEach(function(removedGuide)
                {
                    $scope.loadTableColumnCells(removedGuide, removedGuide.name, true);
                });

                if (guide)
                {
                    $scope.loadTableColumnCells(guide, guide.name, true);
                }
                $scope.loadTableColumnCells(shiftAssignment, shiftAssignment.getKey());
            });
        };

        $scope.getShift = function(shiftAssignment)
        {
            return ($scope.shiftsCollection.shifts.filter(function(shift)
            {
                return shift.id/1 === shiftAssignment.shift_id/1;
            })).pop();
        };

        $scope.returnToCalendar = function()
        {
            IntraControllerActionHandler.priorReturnPath = null;
            IntraControllerActionHandler.priorDate = null;
            IntraControllerActionHandler.priorAction = null;
            IntraControllerActionHandler.priorModel = null;
            IntraControllerActionHandler.returnPath = null;
            IntraControllerActionHandler.model = null;
            IntraControllerActionHandler.action = null;
            IntraControllerActionHandler.date = null;
            IntraControllerActionHandler.stopEvents = false;

            $location.path('/admin/calendar');
        };

        $scope.contactGuides = function(day)
        {
            IntraControllerActionHandler.priorModel = null;
            IntraControllerActionHandler.priorAction = 'open-day-details';
            IntraControllerActionHandler.priorDate = day;
            IntraControllerActionHandler.priorReturnPath = '/admin/day-details';

            IntraControllerActionHandler.action = 'contact-guides';
            IntraControllerActionHandler.model = null;
            IntraControllerActionHandler.date = day;
            IntraControllerActionHandler.stopEvents = false;
            IntraControllerActionHandler.returnPath = '/admin/day-details';
            $scope.changesActive = null;

            $location.url('/admin/contact-guides');

        };

        var promises = [];

        promises.push($scope.taskTypesCollection.load());
        promises.push($scope.tourTypesCollection.load());
        promises.push($scope.usersCollection.load());
        promises.push($scope.shiftsCollection.load());

        $q.all(promises).then(function()
        {

            IntraControllerActionHandler.stopEvents = false;
            $scope.activeDay = IntraControllerActionHandler.date;

            $scope.loadDayDetails($scope.activeDay);
        });
    }]);

})($, angular, document, window);
