(function($, angular, document, window)
{

    angular.module('phillyByFoot')
    /* controller for app */
    .controller('CalendarController', ['$q', '$filter', '$scope', '$http', '$window', '$location',
    'MonthsFactory', 'OrganizationsCollectionFactory', 'TaskTypesCollectionFactory', 'TourTypesCollectionFactory',
    'TaskAssignmentCollectionFactory', 'GuideAssignmentCollectionFactory', 'TaskAssignmentFactory', 'HourSelectFactory',
    'MinuteSelectFactory', 'GuideAssignmentFactory', 'StaticUserFactory', 'IntraControllerActionHandlerFactory',
    'CalendarFactory', 'GuideAvailabilityCollectionFactory', 'GuideAvailabilityFactory','HourSelectFactory', 'MinuteSelectFactory',
    'GuideAssignmentTicketsCollectionFactory', 'TicketTypeCollectionFactory', 'PayPeriodFactory',
    function($q, $filter, $scope, $http, $window, $location, months, OrganizationsCollection, TaskTypesCollection,
             TourTypesCollection, TaskAssignmentCollection, GuideAssignmentCollection, TaskAssignment, HourSelect,
             MinuteSelect, GuideAssignment, StaticUser, IntraControllerActionHandler, Calendar,
             GuideAvailabilityCollection, GuideAvailability, HourSelectFactory, MinuteSelectFactory,
             GuideAssignmentTicketsCollection, TicketTypeCollection, PayPeriod)
    {

        window.scrollTo(0,0);

        $scope.payPeriod = PayPeriod;
        $scope.payPeriodStartDay = new Date($scope.payPeriod.datePicker.start);
        $scope.payPeriodEndDay = new Date($scope.payPeriod.datePicker.end);

        $scope.staticUser = StaticUser;
        $scope.user = IntraControllerActionHandler.model ? IntraControllerActionHandler.model : StaticUser;

        $scope.organizationsCollection = OrganizationsCollection;
        $scope.taskTypesCollection = TaskTypesCollection;
        $scope.tourTypesCollection = TourTypesCollection;
        $scope.taskAssignmentCollection = TaskAssignmentCollection;
        $scope.guideAssignmentCollection = GuideAssignmentCollection;
        $scope.guideAvailabilityCollection = GuideAvailabilityCollection;
        $scope.guideAssignmentTicketsCollection = GuideAssignmentTicketsCollection;
        $scope.calendar = Calendar;
        $scope.editingDay = null;
        $scope.editingAvailability = null;
        $scope.hourOptions = HourSelectFactory;
        $scope.minuteOptions = MinuteSelectFactory;


        $scope.taskAssignmentCollection.empty();
        $scope.guideAssignmentCollection.empty();

        /**
         * If you haven't added notes / created your timesheet by the end of sunday at the end of the pay period,
         * you should not be able to add notes / enter or update your timesheets
         *
         */
        $scope.inPayPeriod = function(day)
        {
            if (1) { return true; }
            if (!day) { return false; }

            var today = new Date();
            var startDay = $scope.payPeriodStartDay;
            var endDay = $scope.payPeriodEndDay;
            var priorStart = startDay.addDays(-14);
            var priorEnd = endDay.addDays(-14);

            today.setHours(24);
            today.setMinutes(0);
            today.setSeconds(0);
            today.setMilliseconds(0);

            endDay = endDay.addDays(1);
            priorEnd = priorEnd.addDays(1);

            /**
             * actual date is within the current pay period.
             */
            if (today.getTime() >= startDay.getTime() && today.getTime() <= endDay.getTime())
            {
                if (day.getTime() >= startDay.getTime() && day.getTime() <= endDay.getTime())
                {
                    return true;
                }
            }

            /**
             * actual date is after the end of the previous pay period
             */
            if (today.getTime() >= priorEnd.getTime() && today.addDays(-3).getTime() <= priorEnd.getTime())
            {
                if (day.getTime() >= priorStart.getTime() && day.getTime() <= priorEnd.getTime())
                {
                    return true;
                }
            }

            return false;
        };

        $scope.updateMonthCallback = function(firstDayOfMonth, lastDayOfMonth)
        {
            $scope.guideAvailabilityCollection.reload($scope.user.id, firstDayOfMonth, lastDayOfMonth);
            $scope.taskAssignmentCollection.reload(firstDayOfMonth, lastDayOfMonth).then(function()
            {
                $scope.guideAssignmentCollection.reload($scope.taskAssignmentCollection.collection).then(function()
                {
                    $scope.guideAssignmentTicketsCollection.reload($scope.guideAssignmentCollection.collection);
                });
            });
        };

        $scope.hasTours = function(day, organization_id)
        {
            var tours = $scope.taskAssignmentCollection.getTaskAssignments(day, organization_id).filter(function(taskAssignment)
            {
                var guideAssignments = $scope.getGuideAssignments(taskAssignment);
                return guideAssignments.length > 0;
            });
            return tours.length > 0;
        };

        $scope.getTours = function(day, organization_id)
        {
            return $scope.taskAssignmentCollection.getTaskAssignments(day, organization_id).filter(function(taskAssignment)
            {
                var guideAssignments = $scope.getGuideAssignments(taskAssignment);

                return taskAssignment.tasktype/1 === 1 && guideAssignments.length > 0;
            });
        };

        $scope.getGuideAssignments = function(taskAssignment)
        {
            return $scope.guideAssignmentCollection.collection.filter(function(guideAssignment)
            {
                if (guideAssignment.guide_id/1 !== $scope.user.id/1) { return false; }
                return guideAssignment.taskassignment_id/1 === taskAssignment.id/1 && guideAssignment.status;
            });
        };

        $scope.openTickets = function(day)
        {
            IntraControllerActionHandler.priorReturnPath = IntraControllerActionHandler.returnPath;
            IntraControllerActionHandler.priorDate = IntraControllerActionHandler.date;
            IntraControllerActionHandler.priorAction = IntraControllerActionHandler.action;
            IntraControllerActionHandler.priorModel = IntraControllerActionHandler.model;

            IntraControllerActionHandler.model = $scope.user;
            IntraControllerActionHandler.returnPath = '/calendar';
            IntraControllerActionHandler.stopEvents = false;
            IntraControllerActionHandler.date = day;
            IntraControllerActionHandler.action = 'time-and-tickets';

            $location.path('/day-details');

        };

        $scope.openSchedule = function(day)
        {
            if (!$scope.hasTours(day)) { return; }

            IntraControllerActionHandler.priorReturnPath = IntraControllerActionHandler.returnPath;
            IntraControllerActionHandler.priorDate = IntraControllerActionHandler.date;
            IntraControllerActionHandler.priorAction = IntraControllerActionHandler.action;
            IntraControllerActionHandler.priorModel = IntraControllerActionHandler.model;

            IntraControllerActionHandler.model = $scope.user;
            IntraControllerActionHandler.returnPath = '/calendar';
            IntraControllerActionHandler.stopEvents = false;
            IntraControllerActionHandler.date = day;
            IntraControllerActionHandler.action = 'show-day-details';

            $location.path('/day-details');
        };

        $scope.getGuideAvailabilities = function(day)
        {
            if (!day) { return []; }

            return $scope.guideAvailabilityCollection.availabilities.filter(function(guideAvailability)
            {
                if (guideAvailability.guide_id/1 !== $scope.user.id/1) { return false; }


                return guideAvailability.starttime >= day && guideAvailability.endtime <= day.addDays(1);
            });
        };

        $scope.cancelEdit = function(availability)
        {
            availability.reload();
            $scope.editingDay = null;
            $scope.editingAvailability = null;
        };

        $scope.saveAvailability = function(availability, id)
        {
            if (!$scope.staticUser.is_admin) { return; }

            if (!id)
            {
                $scope.guideAvailabilityCollection.availabilities.push(availability);
            }

            availability.custom = true;
            availability.save().then(function()
            {
                $scope.editingDay = null;
                $scope.editingAvailability = null;
            });
        };

        $scope.addAvailability = function(day)
        {
            if (!$scope.staticUser.is_admin) { return; }

            $scope.editingAvailability = new GuideAvailability();
            $scope.editingAvailability.availabilitydate = $filter('date')(day, 'MMM dd, yyyy');
            $scope.editingAvailability.starttime = day;
            $scope.editingAvailability.endtime = day;
            $scope.editingAvailability.start_hour = 9;
            $scope.editingAvailability.end_hour = 5;
            $scope.editingAvailability.start_minute = 0;
            $scope.editingAvailability.end_minute = 0;
            $scope.editingAvailability.guide_id = $scope.user.id;
            $scope.editingAvailability.updateAvailabilityTime();

            $scope.editingDay = day;
        };

        $scope.editAvailability = function(availability, day)
        {
            if (!$scope.staticUser.is_admin) { return; }

            $scope.editingDay = day;
            $scope.editingAvailability = availability;
        };

        $scope.deleteAvailability = function(availability)
        {
            if (!$scope.staticUser.is_admin) { return; }

            if (confirm("Are you sure you want to delete this availability?"))
            {
                $scope.guideAvailabilityCollection.deleteEntry(availability);
            }
        };

        var promises = [];

        promises.push($scope.staticUser.load());
        promises.push($scope.organizationsCollection.load());
        promises.push($scope.taskTypesCollection.load());
        promises.push($scope.tourTypesCollection.load());

        $q.all(promises).then(function()
        {
            $scope.calendar.updateMonth($scope.updateMonthCallback);
            $scope.payPeriod.updatePayPeriod(0);


            if ($scope.user.id === $scope.staticUser.id && $scope.staticUser.is_admin)
            {
                $location.path('/admin/guides');
            }
        });
    }]);

})($, angular, document, window);
