(function($, angular, document, window)
{

    angular.module('phillyByFoot')
    .controller('ContactGuidesController', ['$q','$filter','$scope', '$http', '$window', '$location',
    'TaskTypesCollectionFactory', 'TourTypesCollectionFactory', 'UsersCollectionFactory', 'EmailMessageFactory',
    'EmailTemplateCollectionFactory', 'CalendarFactory', 'IntraControllerActionHandlerFactory',
    'GuideAssignmentCollectionFactory', 'TaskAssignmentCollectionFactory',
    function($q, $filter, $scope, $http, $window, $location, TaskTypesCollection, TourTypesCollection,
             UsersCollection, EmailMessage, EmailTemplateCollection, Calendar, IntraControllerActionHandler,
             GuideAssignmentCollection, TaskAssignmentCollection)
    {
        window.scrollTo(0,0);

        $scope.taskTypesCollection = TaskTypesCollection;
        $scope.tourTypesCollection = TourTypesCollection;
        $scope.usersCollection = UsersCollection;
        $scope.emailTemplateCollection = EmailTemplateCollection;
        $scope.taskAssignmentCollection = TaskAssignmentCollection;
        $scope.guideAssignmentCollection = GuideAssignmentCollection;
        $scope.emailMessage = null;
        $scope.returnPath = null;
        $scope.changesActive = false;
        $scope.activeDay = null;

        $scope.tinymceOptions = {
            plugins: 'lists',
            branding : false,
            menubar : 'edit format',
            browser_spellcheck : true,
            content_css : '/css/style.css'
        };

        $scope.getTours = function(day, organization_id)
        {
            return $scope.taskAssignmentCollection.getTaskAssignments(day, organization_id).filter(function(taskAssignment)
            {
                return taskAssignment.tasktype/1 === 1;
            });
        };

        $scope.getTaskType = function(taskAssignment)
        {
            return ($scope.taskTypesCollection.taskTypes.filter(function (taskType)
            {
                return taskAssignment.tasktype / 1 === taskType.id / 1;
            })).pop();
        };

        $scope.getTourType = function(taskAssignment)
        {
            return ($scope.tourTypesCollection.tourTypes.filter(function(tourType)
            {
                return tourType.id/1 === taskAssignment.tourtype/1;
            })).pop();
        };

        $scope.getUnfilteredUsers = function()
        {
            return $scope.usersCollection.users.filter(function(user)
            {
                return user.status && !user.is_admin;
            });
        };

        $scope.getGuide = function(userId)
        {
            if (!userId) { return null; }

            return ($scope.usersCollection.users.filter(function(user)
            {
                return user.id/1 === userId/1;
            })).pop();
        };

        $scope.getGuideAssignments = function(taskAssignment)
        {
            return $scope.guideAssignmentCollection.collection.filter(function(guideAssignment)
            {
                return guideAssignment.taskassignment_id/1 === taskAssignment.id/1;
            });
        };

        $scope.getAssignedGuides = function (taskAssignment)
        {
            return $scope.getGuideAssignments(taskAssignment)
            .filter(function(guideAssignment)
            {
                return guideAssignment.status;
            })
            .map(function(guideAssignment)
            {
                return $scope.getGuide(guideAssignment.guide_id);
            });
        };

        $scope.getAssignedGuidesByDate = function(day)
        {
            if (!day) { return []; }

            var tours = $scope.getTours(day);
            var allGuideAssignments = [];

            tours.forEach(function(tour)
            {
                $scope.getGuideAssignments(tour).forEach(function(guideAssignment)
                {
                    if (guideAssignment.status) { allGuideAssignments.push(guideAssignment); }
                });
            });

            return uniqueArray(allGuideAssignments.map(function(guideAssignment)
            {
                return $scope.getGuide(guideAssignment.guide_id);
            }));
        };

        $scope.contactGuides = function(taskAssignment, activeDay)
        {
            $scope.emailMessage = new EmailMessage();
            $scope.emailMessage.messageType = 'SimpleEmailMessage';
            $scope.emailMessage.messageBody = null;
            $scope.emailMessage.messageSubject = null;

            if (taskAssignment)
            {
                var taskType = $scope.getTaskType(taskAssignment);
                var tourtype = $scope.getTourType(taskAssignment);

                taskType = taskType ? taskType.name : 'Unknown Task Type';
                tourtype = tourtype ? ' (' + tourtype.name + ')' : '';

                $scope.emailMessage.messageSubject = "Your " + taskType + tourtype + " Scheduled on " +
                    $filter('date')(taskAssignment.starttime, 'MMMM d, yyyy') + ' from '+
                    $filter('date')(taskAssignment.starttime, 'h:mm a') + ' to ' +
                    $filter('date')(taskAssignment.endtime, 'h:mm a');
            }

            if (activeDay)
            {
                $scope.emailMessage.messageSubject = "Tasks Scheduled on " + $filter('date')(activeDay, 'MMMM d, yyyy');
            }

            var guides;
            if (taskAssignment)
            {
                guides = $scope.getAssignedGuides(taskAssignment);
            } else if (activeDay)
            {
                guides = $scope.getAssignedGuidesByDate(activeDay);
            } else
            {
                guides = $scope.getUnfilteredUsers();
            }

            $scope.emailMessage.messageRecipients = guides.map(function(guide)
            {
                return {
                    id      : guide.id,
                    name    : guide.name,
                    enabled : guides.length <= 1,
                    email   : null
                };
            });

            $scope.$watchCollection('emailMessage', function(newValue, oldValue)
            {
                if (newValue && oldValue)
                {
                    Object.keys(newValue).forEach(function (property)
                    {
                        if (newValue.hasOwnProperty(property) && typeof newValue[property] !== 'function')
                        {
                            if (newValue[property] !== oldValue[property])
                            {
                                $scope.changesActive = true;
                            }
                        }
                    });
                }
            });

        };

        $scope.sendEmailMessage = function()
        {
            $scope.emailMessage.save().then(function(success)
            {
                if (success)
                {
                    $scope.emailMessage = null;
                    $scope.changesActive = false;
                    $scope.returnToPreviousController();
                }
            });
        };

        $scope.returnToPreviousController = function()
        {
            if ($scope.changesActive && !confirm("You have unsaved changes. Are you sure you wish to leave?"))
            {
                return;
            }

            IntraControllerActionHandler.model = IntraControllerActionHandler.priorModel;
            IntraControllerActionHandler.action = IntraControllerActionHandler.priorAction;
            IntraControllerActionHandler.date = IntraControllerActionHandler.priorDate;
            IntraControllerActionHandler.returnPath = IntraControllerActionHandler.priorReturnPath;
            IntraControllerActionHandler.stopEvents = false;
            IntraControllerActionHandler.priorAction = null;
            IntraControllerActionHandler.priorDate = null;
            IntraControllerActionHandler.priorModel = null;
            IntraControllerActionHandler.priorReturnPath = null;
            IntraControllerActionHandler.stopEvents = false;
            $scope.changesActive = false;

            $location.path($scope.returnPath);

        };

        var promises = [];

        promises.push($scope.taskTypesCollection.load());
        promises.push($scope.tourTypesCollection.load());
        promises.push($scope.usersCollection.load());
        promises.push($scope.emailTemplateCollection.load());

        $q.all(promises).then(function()
        {
            IntraControllerActionHandler.stopEvents = true;
            $scope.activeTaskAssignment = IntraControllerActionHandler.model;
            $scope.activeDay = IntraControllerActionHandler.date;
            $scope.returnPath = IntraControllerActionHandler.returnPath;

            $scope.contactGuides($scope.activeTaskAssignment, $scope.activeDay);

        });
    }]);

})($, angular, document, window);
