(function($, angular, document, window)
{

    angular.module('phillyByFoot')
    /* controller for app */
    .controller('DayDetailsController', ['$q', '$filter', '$scope', '$http', '$window', '$location',
    'IntraControllerActionHandlerFactory', 'StaticUserFactory', 'OrganizationsCollectionFactory',
    'TaskTypesCollectionFactory', 'TourTypesCollectionFactory', 'TaskAssignmentCollectionFactory',
    'GuideAssignmentCollectionFactory', 'UsersCollectionFactory', 'TicketTypeCollectionFactory',
    'GuideAssignmentTicketsCollectionFactory', 'GuideAssignmentTicketFactory', 'HourSelectFactory',
    'MinuteSelectFactory', 'ConditionsSelectFactory', 'PrecipitationSelectFactory','TemperatureSelectFactory',
    'GuideTimeSheetCollectionFactory', 'GuideTimeSheetFactory',
    function($q, $filter, $scope, $http, $window, $location, IntraControllerActionHandler, StaticUser,
             OrganizationsCollection, TaskTypesCollection, TourTypesCollection, TaskAssignmentCollection,
             GuideAssignmentCollection, UsersCollection, TicketTypeCollection, GuideAssignmentTicketsCollection,
             GuideAssignmentTicket, HourSelect, MinuteSelect, ConditionsSelect, PrecipitationSelect,
            TemperatureSelect, GuideTimeSheetCollection, GuideTimeSheet)
    {
        window.scrollTo(0,0);

        if (!IntraControllerActionHandler.date)
        {
            return $location.url('/calendar');
        }

        if (IntraControllerActionHandler.action === 'time-and-tickets')
        {
            IntraControllerActionHandler.stopEvents = true;
        }

        $scope.staticUser = StaticUser;
        $scope.user = IntraControllerActionHandler.model ? IntraControllerActionHandler.model : StaticUser;
        $scope.controllerAction = IntraControllerActionHandler.action;
        $scope.activeDay = IntraControllerActionHandler.date;

        $scope.usersCollection = UsersCollection;
        $scope.organizationsCollection = OrganizationsCollection;
        $scope.taskTypesCollection = TaskTypesCollection;
        $scope.tourTypesCollection = TourTypesCollection;
        $scope.taskAssignmentCollection = TaskAssignmentCollection;
        $scope.guideAssignmentCollection = GuideAssignmentCollection;
        $scope.ticketTypeCollection = TicketTypeCollection;
        $scope.guideAssignmentTicketsCollection = GuideAssignmentTicketsCollection;
        $scope.guideTimeSheetCollection = GuideTimeSheetCollection;

        $scope.hourOptions = HourSelect;
        $scope.minuteOptions = MinuteSelect;
        $scope.conditionsSelect = ConditionsSelect;
        $scope.precipitationSelect = PrecipitationSelect;
        $scope.temperatureSelect = TemperatureSelect;
        $scope.shouldShow = null;
        $scope.isSaving = false;
        $scope.shouldShowTimesheet = null;
        $scope.isLoaded = false;

        $scope.timeRows = [1,2,3,4,5];

        $scope.tinymceOptions = {
            plugins: 'lists',
            branding : false,
            menubar : 'edit format',
            browser_spellcheck : true,
            content_css : '/css/style.css'
        };

        $scope.setShouldShow = function(id)
        {
            if ($scope.shouldShow !== null && $scope.shouldShow === id)
            {
                $scope.shouldShow = null;
                return;
            }
            $scope.shouldShow = id;
        };

        $scope.setShouldShowTimesheet = function(id)
        {
            if ($scope.shouldShowTimesheet !== null && $scope.shouldShowTimesheet === id)
            {
                $scope.shouldShowTimesheet = null;
                return;
            }
            $scope.shouldShowTimesheet = id;
        };

        $scope.getTaskType = function(taskAssignment)
        {
            return ($scope.taskTypesCollection.taskTypes.filter(function(taskType)
            {
                return taskType.id/1 === taskAssignment.tasktype/1;
            })).pop();
        };

        $scope.getTourType = function(taskAssignment)
        {
            return ($scope.tourTypesCollection.tourTypes.filter(function(tourType)
            {
                return tourType.id/1 === taskAssignment.tourtype/1;
            })).pop();
        };

        $scope.hasOtherGuides = function(taskAssignment)
        {
            return $scope.getOtherGuides(taskAssignment).length > 0;
        };

        $scope.getOtherGuides = function(taskAssignment)
        {
            var guideAssignments = $scope.getGuideAssignments(taskAssignment).filter(function(guideAssignment)
            {
                return guideAssignment.guide_id/1 !== $scope.user.id/1;
            });

            return guideAssignments.map(function(guideAssignment)
            {
                return $scope.getUser(guideAssignment.guide_id);
            });
        };

        $scope.getUser = function(id)
        {
            return ($scope.usersCollection.users.filter(function(user)
            {
                return user.id/1 === id/1;
            })).pop();
        };

        $scope.hasTaskAssignments= function(organization_id)
        {
            return $scope.getTaskAssignments(organization_id).length;
        };

        $scope.getTaskAssignments = function(organization_id)
        {
            return $scope.taskAssignmentCollection.getTaskAssignments($scope.activeDay, organization_id).filter(function(taskAssignment)
            {
                var guideAssignments = $scope.getGuideAssignments(taskAssignment).filter(function(guideAssignment)
                {
                    return (guideAssignment.guide_id/1 === $scope.user.id/1);
                });

                return (guideAssignments.length > 0);
            });
        };

        $scope.getGuideAssignments = function(taskAssignment)
        {
            return $scope.guideAssignmentCollection.collection.filter(function(guideAssignment)
            {
                return guideAssignment.taskassignment_id/1 === taskAssignment.id/1 && guideAssignment.status;
            });
        };

        $scope.getGuideAssignment = function(taskAssignment)
        {
            return ($scope.getGuideAssignments(taskAssignment).filter(function(guideAssignment)
            {
                return guideAssignment.guide_id/1 === $scope.user.id/1;
            })).pop();
        };

        $scope.getTicket = function(taskAssignment, ticketType)
        {

            var guideAssignment = $scope.getGuideAssignment(taskAssignment);

            var ticket = ($scope.guideAssignmentTicketsCollection.collection.filter(function(guideAssignmentTicket)
            {
                return guideAssignmentTicket.assignment_id/1 === guideAssignment.id/1 &&
                       guideAssignmentTicket.ticket_id/1 === ticketType.id/1;
            })).pop();

            if (!ticket)
            {
                ticket = new GuideAssignmentTicket();
                ticket.assignment_id = guideAssignment.id/1;
                ticket.ticket_id = ticketType.id/1;
                ticket.adult = ticketType.adult ? 0 : null;
                ticket.child = ticketType.child ? 0 : null;
                ticket.combined = ticketType.combined ? 0 : null;

                $scope.guideAssignmentTicketsCollection.collection.push(ticket);
            }

            return ticket;
        };

        $scope.filteredTicketTypes = function(organizationId)
        {
            return $scope.ticketTypeCollection.collection.filter(function(ticketType)
            {
                if (!ticketType.status) { return false; }

                return (ticketType.organization_id !== null && organizationId !== null) ?
                       ticketType.organization_id/1 === organizationId/1 : true;
            });
        };

        $scope.getTicketTotals = function(taskAssignment, column, ticketType)
        {

            var guideAssignment = $scope.getGuideAssignment(taskAssignment);

            var totalAdult = 0, totalChild = 0, totalCombined = 0;

            var filteredTicketTypes = ticketType ? [ticketType] : $scope.filteredTicketTypes(guideAssignment.organization_id);

            var ticketsList = filteredTicketTypes.map(function(ticketType)
            {
                return $scope.getTicket(taskAssignment, ticketType);
            });

            ticketsList.map(function(ticket)
            {
                totalAdult    += ticket.adult    ? ticket.adult/1    : 0;
                totalChild    += ticket.child    ? ticket.child/1    : 0;
                totalCombined += ticket.combined ? ticket.combined/1 : 0;
            });

            var totalAll    = totalAdult    ? totalAdult    : 0;
            totalAll       += totalChild    ? totalChild    : 0;
            totalAll       += totalCombined ? totalCombined : 0;

            switch (column)
            {
                case 'adult':    return totalAdult    ? totalAdult    : null;
                case 'child':    return totalChild    ? totalChild    : null;
                case 'combined': return totalCombined ? totalCombined : null;
                default:         return totalAll      ? totalAll      : null;
            }
        };

        $scope.ticketReconciliationComplete = function(taskAssignment)
        {
            var complete = false;

            if (!$scope.isLoaded) { return true; }

            var guideAssignment = $scope.getGuideAssignment(taskAssignment);

            complete = !!guideAssignment.id;

            $scope.filteredTicketTypes(taskAssignment.organization_id).forEach(function(ticketType)
            {
                var ticket = $scope.getTicket(taskAssignment, ticketType);

                if (!ticket.id) { complete = false; }
            });

            return complete && !$scope.hasError(taskAssignment);
        };

        $scope.hasError = function(taskAssignment)
        {
            var guideAssignment = $scope.getGuideAssignment(taskAssignment);

            var hasError = ((guideAssignment.totaltickets/1 !== $scope.getTicketTotals(taskAssignment)/1) &&
                                guideAssignment.discrepancy.length < 6) && !guideAssignment.noticketscollected;
            return hasError;

        };

        $scope.saveTickets = function(taskAssignment)
        {
            $scope.isSaving = true;

            var guideAssignment = $scope.getGuideAssignment(taskAssignment);

            guideAssignment.save().then(function()
            {
                var promises = [];

                $scope.filteredTicketTypes(taskAssignment.organization_id).forEach(function(ticketType)
                {
                    var ticket = $scope.getTicket(taskAssignment, ticketType);
                    if (ticket)
                    {
                        promises.push(ticket.save());
                    }
                });

                $q.all(promises).then(function()
                {
                    $scope.isSaving = false;
                });

            });

        };

        $scope.getSheet = function(organization_id)
        {
            var timeSheet = ($scope.guideTimeSheetCollection.collection.filter(function(timeSheet)
            {
                var assignmentDate = new Date(timeSheet.assignmentdate + ' 00:00:00');

                return assignmentDate.getTime() === $scope.activeDay.getTime() &&
                       timeSheet.guide_id/1 === $scope.user.id/1 &&
                       timeSheet.organization_id/1 === organization_id/1;
            })).pop();

            if (!timeSheet)
            {
                timeSheet = new GuideTimeSheet();
                timeSheet.guide_id = $scope.user.id/1;
                timeSheet.organization_id = organization_id/1;
                timeSheet.assignmentdate = $filter('date')($scope.activeDay, 'yyyy-MM-dd');
                $scope.guideTimeSheetCollection.collection.push(timeSheet);
            }

            return timeSheet;
        };

        $scope.updateSheetTime = function(row, which, organization_id)
        {
            var timeSheet = $scope.getSheet(organization_id);

            timeSheet.updateTimes(which + '_' + row);
        };

        $scope.removeTime = function(row, organization_id)
        {
            var timeSheet = $scope.getSheet(organization_id);
            timeSheet.removeTime('starttime_' + row);
            timeSheet.removeTime('endtime_' + row);
        };

        $scope.getSecondsAssigned = function(organization_id)
        {
            var totalScheduledSeconds = 0;
            $scope.getTaskAssignments(organization_id).forEach(function(assignment)
            {
                totalScheduledSeconds += assignment.getSecondsScheduled();
            });
            return totalScheduledSeconds;
        };

        $scope.getTimeAssigned = function(organization_id)
        {
            var totalScheduledSeconds = $scope.getSecondsAssigned(organization_id);

            var hours = Math.trunc(totalScheduledSeconds/60/60);
            var minutes = (totalScheduledSeconds/60) % 60;

            return hours + ':' + (minutes < 10 ? '0' + minutes : minutes);
        };

        $scope.getSecondsWorked = function(organization_id)
        {
            return $scope.getSheet(organization_id).getSecondsWorked();
        };

        $scope.getTimeWorked = function(organization_id)
        {
            return $scope.getSheet(organization_id).getTimeWorked();
        };

        $scope.hasTimeError = function(row, organization_id)
        {
            var timeSheet = $scope.getSheet(organization_id);

            if (row > 1)
            {
                return (timeSheet['starttime_' + row] || timeSheet['endtime_' + row]) ?
                        timeSheet['starttime_' + row] >= timeSheet['endtime_' + row] : false;
            }

            return !timeSheet.starttime_1 || !timeSheet.endtime_1 || timeSheet.starttime_1 >= timeSheet.endtime_1;
        };

        $scope.saveTimesheet = function(organization_id)
        {
            $scope.isSaving = true;

            $scope.getSheet(organization_id).save().then(function()
            {
                $scope.isSaving = false;
            });
        };

        $scope.timeSheetHasError = function(organization_id)
        {
            var timeSheet = $scope.getSheet(organization_id);

            var hasTimeError = false;

            for (var i=1; i<=5; i++)
            {
                if ($scope.hasTimeError(i, organization_id))
                {
                    hasTimeError = true;
                    break;
                }
            }

            return (!timeSheet.temperature || !timeSheet.precipitation || !timeSheet.conditions ||
                   hasTimeError || !timeSheet.notes || timeSheet.notes.length < 8);
        };

        $scope.timeSheetCompleted = function(organization_id)
        {
            if (!$scope.isLoaded) { return true; }
            return !!$scope.getSheet(organization_id).id && !$scope.timeSheetHasError(organization_id);
        };

        $scope.returnToCalendar = function()
        {
            $location.path('/calendar');
        };

        var promises = [];

        promises.push($scope.staticUser.load());
        promises.push($scope.usersCollection.load());
        promises.push($scope.organizationsCollection.load());
        promises.push($scope.taskTypesCollection.load());
        promises.push($scope.tourTypesCollection.load());
        promises.push($scope.ticketTypeCollection.load());
        promises.push($scope.guideTimeSheetCollection.reload($scope.activeDay, $scope.activeDay));

        $q.all(promises).then(function()
        {
            $scope.isLoaded = true;
        });
    }]);

    if (!window.scrollFix)
    {
        window.scrollFix = $(window).scroll(function (eo)
        {
            var parentTop = $('.sticky-fix').parent().offset();
            var windowTop = $(window).scrollTop();

            parentTop = parentTop ? parentTop.top : 0;

            var total = windowTop - parentTop;

            if (total > 0)
            {
                $('.sticky-fix').css({
                    top : (total + 51) + "px",
                    position : 'relative',
                    'z-index' : 100
                });
            } else
            {
                $('.sticky-fix').css({
                    top : '',
                    'z-index' : '',
                });
            }
        });
    }

})($, angular, document, window);
