(function($, angular, document, window)
{

    angular.module('phillyByFoot')
    /* controller for app */
    .controller('EmailTemplatesController', ['$q', '$filter', '$scope', '$http', '$window', '$location',
    'EmailTemplateCollectionFactory',
    function($q, $filter, $scope, $http, $window, $location, EmailTemplateCollection)
    {
        $scope.emailTemplateCollection = EmailTemplateCollection;
        $scope.activeTemplate = null;
        $scope.activeTemplateId = null;

        $scope.tinymceOptions = {
            plugins: 'lists link image',
            branding : false,
            menubar : 'edit format insert',
            browser_spellcheck : true,
            content_css : '/css/style.css',
            file_picker_types : 'image',
            file_picker_callback : function(callback, value, meta)
            {
                if (meta.filetype === 'image')
                {
                    var image = $('filepicker-upload');
                    var input = document.getElementsByName('filepicker-upload');

                    $(input).click();
                    $(input).on('change', function()
                    {
                        var file = this.files[0];

                        var reader = new FileReader();
                        reader.onload = function ()
                        {
                            /*
                             Note: Now we need to register the blob in TinyMCEs image blob
                             registry. In the next release this part hopefully won't be
                             necessary, as we are looking to handle it internally.
                             */
                            var id = 'blobid' + (new Date()).getTime();
                            var blobCache = tinymce.activeEditor.editorUpload.blobCache;
                            var base64 = reader.result.split(',')[1];
                            var blobInfo = blobCache.create(id, file, base64);
                            blobCache.add(blobInfo);
                            /* call the callback and populate the Title field with the file name */
                            callback(blobInfo.blobUri(), {title: file.name});
                        };
                        reader.readAsDataURL(file);

                    });
                }
            }
        };


        $scope.updateActiveTemplate = function()
        {
            if ($scope.activeTemplateId)
            {
                $scope.activeTemplate = ($scope.emailTemplateCollection.collection.filter(function (template)
                {
                    return template.id / 1 === $scope.activeTemplateId / 1;
                })).pop();
            }
        };

        $scope.saveTemplate = function()
        {
            $scope.activeTemplate.save().then(function()
            {
                $scope.activeTemplate = null;
                $scope.activeTemplateId = null;
            });
        };

        var promises = [];

        promises.push($scope.emailTemplateCollection.load());

        $q.all(promises).then(function()
        {
        });
    }]);

})($, angular, document, window);
