(function($, angular, document, window)
{

    angular.module('phillyByFoot')
    /* controller for app */
    .controller('GuidesController', ['$q', '$filter', '$scope', '$http', '$window', '$location', 'StaticUserFactory',
    'UsersCollectionFactory', 'UserFactory', 'OrganizationsCollectionFactory', 'GuideAvailabilityCollectionFactory',
    'GuideAvailabilityFactory', 'HourSelectFactory', 'MinuteSelectFactory', 'AvailabilitiesCollectionFactory',
    'AvailabilitiesFactory', 'DaySelectFactory', 'IntraControllerActionHandlerFactory', 'SystemMessagingFactory',
    function($q, $filter, $scope, $http, $window, $location, StaticUser, UsersCollection, User, OrganizationsCollection,
             GuideAvailabilityCollection, GuideAvailability, HourSelectFactory, MinuteSelectFactory,
             AvailabilitiesCollection, Availability, DaySelectFactory, IntraControllerActionHandler, SystemMessaging)
    {
        $scope.staticUser = StaticUser;
        $scope.usersCollection = UsersCollection;
        $scope.organizationsCollection = OrganizationsCollection;
        $scope.guideAvailabilityCollection = GuideAvailabilityCollection;
        $scope.availabilitiesCollection = AvailabilitiesCollection;
        $scope.sortType = 'fullName';
        $scope.editingUser = null;
        $scope.openManager = null;
        $scope.phoneRegex = new RegExp(/^[(]{0,1}[0-9]{3}[)]{0,1}[-\s\.]{0,1}[0-9]{3}[-\s\.]{0,1}[0-9]{4}$/);
        $scope.hourOptions = HourSelectFactory;
        $scope.minuteOptions = MinuteSelectFactory;
        $scope.dayOptions = DaySelectFactory;
        $scope.offline = false;
        $scope.filteredUsers = [];
        $scope.currentPage = 1;

        $scope.guideAvailabilityCollection.empty();
        $scope.availabilitiesCollection.empty();

        $scope.updateFilteredUsers = function()
        {
            $scope.filteredUsers = $scope.usersCollection.users.filter(function(user)
            {
                if (user.is_admin) { return false; }
                if ($scope.offline && !user.status) { return true; }
                return user.status;
            });
        };

        $scope.getStartDate = function(startdate)
        {
            var sd = new Date(startdate);
            sd.setHours(1);
            sd.setMinutes(0);
            sd.setSeconds(0);
            sd.setMilliseconds(0);

            return sd;
        };

        $scope.setSort = function(which)
        {
            switch (which)
            {
                case 'fullName' :
                    if ($scope.sortType === 'fullName') { $scope.sortType = '-fullName'; }
                    else                            { $scope.sortType = 'fullName'; }
                    break;
                case 'status':
                    if ($scope.sortType === 'status') { $scope.sortType = '-status'; }
                    else                              { $scope.sortType = 'status'; }
                    break;
                case 'lastlog':
                    if ($scope.sortType === 'lastlog') { $scope.sortType = '-lastlog'; }
                    else                               { $scope.sortType = 'lastlog'; }
                    break;
            }

        };

        $scope.loginAs = function(user)
        {
            $http({
                method : 'GET',
                url : '/wstr/api/user/' + user.id + '?loginAs=true'
            }).then(function(response)
            {
                SystemMessaging.sendMessage(response.data);
                if (response.data.hasOwnProperty('authentication') && response.data.authentication === 'success')
                {
                    window.open('/wstr/application/members');
                }
            }, function (response)
            {
                SystemMessaging.sendMessage(response.data);
            });
        };

        $scope.toggleAvailabilityManager = function(user)
        {
            if ($scope.openManager !== null && $scope.openManager === user)
            {
                $scope.openManager = null;
            } else
            {
                $scope.openManager = user;
            }
        };

        $scope.editUser = function(user)
        {
            if ($scope.editingUser !== null && $scope.editingUser === user)
            {
                $scope.editingUser = null;
            } else
            {
                $scope.editingUser = user;
                $scope.openManager = user;
                // $scope.guideAvailabilityCollection.reload(user.id, new Date().addDays(-7));
                $scope.availabilitiesCollection.reload(user.id);
            }
        };

        $scope.saveUser = function(user)
        {
            user.save();
            $scope.editingUser = null;
        };

        $scope.deleteUser = function(user)
        {
            if (confirm("Are you sure you wish to delete this user?"))
            {
                $scope.editingUser = null;
                $scope.usersCollection.deleteUser(user);
            }
        };

        $scope.addUser = function()
        {
            var user = new User();
            user.status = true;
            $scope.usersCollection.users.push(user);
            $scope.editingUser = user;
            $scope.guideAvailabilityCollection.availabilities = [];
            $scope.availabilitiesCollection.collection = [];
            $scope.updateFilteredUsers();
        };

        $scope.saveAvailability = function(availability)
        {
            availability.save();
        };

        $scope.deleteAvailability = function(availability)
        {
            if (confirm("Are you sure you wish to delete this availability?"))
            {
                $scope.availabilitiesCollection.deleteEntry(availability);
                // $scope.guideAvailabilityCollection.deleteEntry(availability);
            }
        };

        $scope.addAvailability = function(user)
        {

            var startOfMonth = new Date();
            startOfMonth.setMonth(startOfMonth.getMonth() + 1);
            startOfMonth.setDate(1);

            var endOfMonth = new Date();
            endOfMonth.setMonth(startOfMonth.getMonth() + 1);
            endOfMonth.setDate(1);
            endOfMonth = endOfMonth.addDays(-1);

            var availability = new Availability();
            availability.guide_id = user.id;
            availability.startdate = $filter('date')(startOfMonth, 'MMM dd, yyyy');
            availability.enddate = $filter('date')(endOfMonth, 'MMM dd, yyyy');
            availability.dayofweek = 0;
            availability.starttime = startOfMonth;
            availability.start_minute = 0;
            availability.start_hour = 6;
            availability.endtime = endOfMonth;
            availability.end_hour = 6;
            availability.end_minute = 0;
            availability.updateAvailabilityTime();

            $scope.availabilitiesCollection.collection.push(availability);
            availability.save();
        };

        $scope.cloneAvailability = function(availability)
        {
            var newAvailability = new Availability();
            newAvailability.guide_id = availability.guide_id;
            newAvailability.startdate = $filter('date')(new Date(availability.startdate + " 00:00:00"), 'MMM dd, yyyy');
            newAvailability.enddate = $filter('date')(new Date(availability.enddate + " 00:00:00"), 'MMM dd, yyyy');
            newAvailability.dayofweek = availability.dayofweek;
            newAvailability.starttime = availability.starttime;
            newAvailability.start_hour = availability.start_hour;
            newAvailability.start_minute = availability.start_minute;
            newAvailability.endtime = availability.endtime;
            newAvailability.end_hour = availability.end_hour;
            newAvailability.end_minute = availability.end_minute;

            $scope.availabilitiesCollection.collection.push(newAvailability);
            newAvailability.save();
            availability.reload();
        };

        $scope.getOrderedAvailabilities = function()
        {
            return $scope.availabilitiesCollection.collection.sort(function(a, b)
            {
                var a_start = new Date(a.startdate + " 00:00:00").getTime() + '_';
                var b_start = new Date(b.startdate + " 00:00:00").getTime() + '_';

                if (a_start === b_start)
                {
                    return a.dayofweek > b.dayofweek ? 1 : (b.dayofweek > a.dayofweek ? -1 : 0);
                }

                return a_start > b_start ? -1 : (b_start > a_start ? 1 : 0);
            });
        };

        $scope.openUserCalendar = function(user)
        {
            IntraControllerActionHandler.model = user;
            IntraControllerActionHandler.action = 'view-user-calendar';
            IntraControllerActionHandler.date = null;
            IntraControllerActionHandler.stopEvents = false;
            IntraControllerActionHandler.returnPath = '/admin/guides';

            $location.path('/calendar');
        };

        var promises = [];

        promises.push($scope.staticUser.load());
        promises.push($scope.usersCollection.load());
        promises.push($scope.organizationsCollection.load());

        $q.all(promises).then(function()
        {
            $scope.updateFilteredUsers();
        });
    }]);

})($, angular, document, window);
