(function($, angular, document, window)
{

    angular.module('phillyByFoot')
    /* controller for app */
    .controller('TicketBreakdownController', ['$q', '$filter', '$scope', '$http', '$window', '$location',
    'TicketTypeCollectionFactory', 'UsersCollectionFactory', 'PayPeriodFactory', 'OrganizationsCollectionFactory',
    'TaskAssignmentCollectionFactory', 'GuideAssignmentCollectionFactory', 'TaskTypesCollectionFactory',
    'TourTypesCollectionFactory', 'GuideAssignmentTicketsCollectionFactory', 'GuideAssignmentTicketFactory',
    function($q, $filter, $scope, $http, $window, $location, TicketTypeCollection, UsersCollection, PayPeriod,
             OrganizationsCollection, TaskAssignmentCollection, GuideAssignmentCollection,
             TaskTypesCollection, TourTypesCollection, GuideAssignmentTicketsCollection,
             GuideAssignmentTicket)
    {
        $scope.usersCollection = UsersCollection;
        $scope.organizationsCollection = OrganizationsCollection;
        $scope.taskAssignmentCollection = TaskAssignmentCollection;
        $scope.guideAssignmentCollection = GuideAssignmentCollection;
        $scope.taskTypesCollection = TaskTypesCollection;
        $scope.tourTypesCollection = TourTypesCollection;
        $scope.ticketTypeCollection = TicketTypeCollection;
        $scope.guideAssignmentTicketsCollection = GuideAssignmentTicketsCollection;
        $scope.filteredTicketTypeBreakdownList = [];
        $scope.payPeriod = PayPeriod;
        $scope.isLoading = false;


        $scope.taskAssignmentCollection.empty();
        $scope.guideAssignmentCollection.empty();
        $scope.guideAssignmentTicketsCollection.empty();

        $scope.activeOrganization = null;

        $scope.showArchiveTicketTypes = false;

        $scope.orgEnabled = {
            constitutional : true,
            spirits : true
        };

        $scope.tinymceOptions = {
            plugins: 'lists',
            branding : false,
            menubar : 'edit format',
            browser_spellcheck : true,
            content_css : '/css/style.css'
        };

        $scope.updatePayPeriod = function(which, startEnd)
        {

            if ($scope.isLoading) { return; }

            $scope.isLoading = true;

            $scope.payPeriod.updatePayPeriod(which, startEnd, function()
            {
                var start = new Date($scope.payPeriod.datePicker.start);
                var end   = new Date($scope.payPeriod.datePicker.end);

                var promises = [];

                promises.push($scope.taskAssignmentCollection.reload(start, end));

                $q.all(promises).then(function()
                {
                    $scope.guideAssignmentCollection.reload($scope.taskAssignmentCollection.collection).then(function()
                    {
                        $scope.guideAssignmentTicketsCollection.reload($scope.guideAssignmentCollection.collection).then(function()
                        {
                            $scope.isLoading = false;
                        });
                    });

                    $scope.payPeriod.activeDays.map(function(day)
                    {
                        day.taskAssignments = $scope.taskAssignmentCollection.getTaskAssignments(day.day);
                    });
                });

            });
        };

        $scope.isRenderingSlowed = function()
        {
            var start = new Date($scope.payPeriod.datePicker.start);
            var end   = new Date($scope.payPeriod.datePicker.end);

            var daysBetween = (Math.abs(start - end)/1000/60/60/24);
            return daysBetween >= 120;
        };

        
        $scope.toggleOrganizations = function(which)
        {
            if (which === 'spirits')
            {
                $scope.orgEnabled.constitutional = !$scope.orgEnabled.constitutional;
            } else
            {
                $scope.orgEnabled.spirits = !$scope.orgEnabled.spirits;
            }
            if ($scope.orgEnabled.spirits)
            {
                $scope.activeOrganization = $scope.getOrganization(2);
            } else
            {
                $scope.activeOrganization = $scope.getOrganization(1);
            }
            $scope.setupFilteredTicketBreakdown();
        };

        $scope.getTaskAssignmentById = function(id)
        {
            if ($scope.isLoading) { return null; }

            return ($scope.taskAssignmentCollection.collection.filter(function(assignment){
                return assignment.id/1 === id/1;
            })).pop();
        };

        $scope.getGuideAssignmentByTaskId = function(id)
        {
            if ($scope.isLoading) { return null; }

            return ($scope.guideAssignmentCollection.collection.filter(function(assignment)
            {
                return assignment.taskassignment_id/1 === id/1;
            })).pop();
        };

        $scope.getGuideAssignmentsByUserId = function(user_id)
        {
            if ($scope.isLoading) { return null; }

            return $scope.guideAssignmentCollection.collection.filter(function(assignment)
            {
                return assignment.guide_id/1 === user_id/1;
            });
        };

        $scope.getFilteredTaskAssignments = function(dayDetails)
        {
            if ($scope.isLoading) { return null; }

            var taskAssignments = dayDetails && dayDetails.taskAssignments ? dayDetails.taskAssignments :
                                  $scope.taskAssignmentCollection.collection;

            return taskAssignments.filter(function (taskAssignment)
            {
                if (taskAssignment.organization_id/1 !== $scope.activeOrganization.id/1) { return false; }
                return taskAssignment.tasktype / 1 === 1 && taskAssignment.tourtype / 1 === 1;
            });
        };

        $scope.getFilteredGuideAssignments = function(dayDetails, user)
        {
            if ($scope.isLoading) { return null; }

            var filteredAssignments = $scope.getFilteredTaskAssignments(dayDetails);

            var assignmentIds = filteredAssignments.map(function(taskAssignment)
            {
                return taskAssignment.id/1;
            });

            return $scope.guideAssignmentCollection.collection.filter(function (guideAssignment)
            {
                if ((user && guideAssignment.guide_id / 1 !== user.id / 1) || guideAssignment.guide_id/1 === 0)
                {
                    return false;
                }
                return assignmentIds.indexOf(guideAssignment.taskassignment_id) >= 0;
            });
        };

        $scope.getTicketCount = function(dayDetails, user)
        {
            if ($scope.isLoading) { return null; }

            var total = 0;

            var guideAssignments = $scope.getFilteredGuideAssignments(dayDetails, user);

            if (guideAssignments.length <= 0) { return null; }

            guideAssignments.map(function (guideAssignment)
            {
                total += guideAssignment.totaltickets ? guideAssignment.totaltickets : 0;
            });

            return total;
        };

        $scope.getDailyTicketTotal = function(dayDetails, ticketType)
        {
            if ($scope.isLoading) { return null; }

            var total = 0;

            var guideAssignments = $scope.getFilteredGuideAssignments(dayDetails);

            for (var i=0; i<guideAssignments.length; i++)
            {
                var guideAssignment = guideAssignments[i];

                var _ticketType = ticketType ? ticketType.ticketType : null;

                var totalAdult    = $scope.getTicketTotals(guideAssignment, 'adult',    _ticketType);
                var totalChild    = $scope.getTicketTotals(guideAssignment, 'child',    _ticketType);
                var totalCombined = $scope.getTicketTotals(guideAssignment, 'combined', _ticketType);

                if ((ticketType && ticketType.adult) || !ticketType)
                {
                    total += totalAdult ? totalAdult : 0;
                }

                if ((ticketType && ticketType.child) || !ticketType)
                {
                    total += totalChild ? totalChild : 0;
                }

                if ((ticketType && ticketType.combined) || !ticketType)
                {
                    total += totalCombined ? totalCombined : 0;
                }
            }

            return total;
        };

        $scope.getFilteredUsers = function()
        {
            if ($scope.isLoading) { return null; }

            return $scope.usersCollection.users.filter(function(user)
            {
                if (!user.status) { return false; }
                if (user.organization_constitutional && $scope.orgEnabled.constitutional) { return true; }
                if (user.organization_spirits && $scope.orgEnabled.spirits) { return true; }
            });
        };

        $scope.getOrganization = function(id)
        {
            return ($scope.organizationsCollection.organizations.filter(function(org)
            {
                return org.id/1 === id/1;
            })).pop();
        };

        $scope.setupFilteredTicketBreakdown = function()
        {
            var ticketTypes = $scope.filteredTicketTypes($scope.activeOrganization.id);

            $scope.filteredTicketTypeBreakdownList = [];

            for (var i=0; i<ticketTypes.length; i++)
            {
                var ticketType = ticketTypes[i];

                if (ticketType.adult)
                {
                    $scope.filteredTicketTypeBreakdownList.push({
                        adult : true,
                        child : false,
                        combined : false,
                        subScript : 'Adult',
                        ticketType : ticketType
                    });
                }

                if (ticketType.child)
                {
                    $scope.filteredTicketTypeBreakdownList.push({
                        adult : false,
                        child : true,
                        combined : false,
                        subScript : 'Child',
                        ticketType : ticketType
                    });
                }

                if (ticketType.combined)
                {
                    $scope.filteredTicketTypeBreakdownList.push({
                        adult : false,
                        child : false,
                        combined : true,
                        subScript : null,
                        ticketType : ticketType
                    });
                }
            }
        };

        $scope.filteredTicketTypes = function(organizationId)
        {
            return $scope.ticketTypeCollection.collection.filter(function(ticketType)
            {
                if (!$scope.showArchiveTicketTypes && !ticketType.status) { return false; }
                return (ticketType.organization_id !== null && organizationId !== null) ?
                       ticketType.organization_id/1 === organizationId/1 : true;
            });
        };

        $scope.getTicketTotals = function(guideAssignment, column, ticketType)
        {
            if ($scope.isLoading) { return null; }
            if (!guideAssignment) { return null; }

            var totalAdult = 0, totalChild = 0, totalCombined = 0;

            var filteredTicketTypes = ticketType ? [ticketType] : $scope.filteredTicketTypes(guideAssignment.organization_id);

            var ticketsList = filteredTicketTypes.map(function(ticketType)
            {
                return $scope.getTicket(guideAssignment, ticketType);
            });

            ticketsList.map(function(ticket)
            {
                totalAdult    += ticket.adult    ? ticket.adult/1    : 0;
                totalChild    += ticket.child    ? ticket.child/1    : 0;
                totalCombined += ticket.combined ? ticket.combined/1 : 0;
            });

            var totalAll    = totalAdult    ? totalAdult    : 0;
            totalAll       += totalChild    ? totalChild    : 0;
            totalAll       += totalCombined ? totalCombined : 0;

            switch (column)
            {
                case 'adult':    return totalAdult    ? totalAdult    : null;
                case 'child':    return totalChild    ? totalChild    : null;
                case 'combined': return totalCombined ? totalCombined : null;
                default:         return totalAll      ? totalAll      : null;
            }
        };

        $scope.getGuideAssignmentTicketTotal = function(guideAssignment, ticketType)
        {
            if ($scope.isLoading) { return null; }
            if (guideAssignment.noticketscollected)
            {
                return 0;
            }
            var ticketTypesList = ticketType ? [ticketType] : $scope.filteredTicketTypeBreakdownList;

            var guideTicketsList = ticketTypesList.map(function(ticketType)
            {
                return $scope.getTicket(guideAssignment, ticketType.ticketType);
            });

            var total = 0;

            for (var i=0; i<ticketTypesList.length; i++)
            {
                var guideTicket = guideTicketsList[i];
                var _ticketType = ticketTypesList[i];

                if (_ticketType.adult)
                {
                    total += guideTicket.adult ? guideTicket.adult : 0;
                }
                if (_ticketType.child)
                {
                    total += guideTicket.child ? guideTicket.child : 0;
                }
                if (_ticketType.combined)
                {
                    total += guideTicket.combined ? guideTicket.combined : 0;
                }
            }

            return total;
        };

        $scope.getTicket = function(guideAssignment, ticketType)
        {
            if ($scope.isLoading) { return null; }
            if (!guideAssignment || !ticketType) { return null; }

            var ticket = ($scope.guideAssignmentTicketsCollection.collection.filter(function(guideAssignmentTicket)
            {
                return guideAssignmentTicket.assignment_id/1 === guideAssignment.id/1 &&
                       guideAssignmentTicket.ticket_id/1 === ticketType.id;
            })).pop();

            if (!ticket)
            {
                ticket = new GuideAssignmentTicket();
                ticket.assignment_id = guideAssignment.id/1;
                ticket.ticket_id = ticketType.id/1;
                ticket.adult = ticketType.adult ? 0 : null;
                ticket.child = ticketType.child ? 0 : null;
                ticket.combined = ticketType.combined ? 0 : null;

                $scope.guideAssignmentTicketsCollection.collection.push(ticket);
            }

            return ticket;
        };

        $scope.getUserName = function(userId)
        {
            if ($scope.isLoading) { return null; }

            var user = ($scope.usersCollection.users.filter(function(user)
            {
                return user.id/1 === userId/1;
            })).pop();

            return user ? user.name : null;
        };

        var promises = [];

        promises.push($scope.usersCollection.load());
        promises.push($scope.organizationsCollection.load());
        promises.push($scope.taskTypesCollection.load());
        promises.push($scope.tourTypesCollection.load());
        promises.push($scope.ticketTypeCollection.load());

        $scope.isLoading = true;
        $q.all(promises).then(function()
        {
            $scope.isLoading = false;
            $scope.updatePayPeriod(0);
            $scope.toggleOrganizations('constitutional');

        });
    }]);

})($, angular, document, window);
