(function($, angular, document, window)
{

    angular.module('phillyByFoot')
    /* controller for app */
    .controller('TicketReconciliationController', ['$q', '$scope', '$http', '$filter', '$window',
    '$location', 'PayPeriodFactory', 'UsersCollectionFactory', 'OrganizationsCollectionFactory',
    'TaskAssignmentCollectionFactory', 'GuideAssignmentCollectionFactory','TaskTypesCollectionFactory',
    'TourTypesCollectionFactory', 'TicketTypeCollectionFactory', 'GuideAssignmentTicketsCollectionFactory',
    'GuideAssignmentTicketFactory', 'TicketReconciliationMapCollectionFactory',
    function($q, $scope, $http, $filter, $window, $location, PayPeriod, UsersCollection, OrganizationsCollection,
             TaskAssignmentCollection, GuideAssignmentCollection, TaskTypesCollection, TourTypesCollection,
             TicketTypeCollection, GuideAssignmentTicketsCollection, GuideAssignmentTicket,
             TicketReconciliationMapCollection)
    {
        $scope.usersCollection = UsersCollection;
        $scope.organizationsCollection = OrganizationsCollection;
        $scope.taskAssignmentCollection = TaskAssignmentCollection;
        $scope.guideAssignmentCollection = GuideAssignmentCollection;
        $scope.taskTypesCollection = TaskTypesCollection;
        $scope.tourTypesCollection = TourTypesCollection;
        $scope.ticketTypeCollection = TicketTypeCollection;
        $scope.guideAssignmentTicketsCollection = GuideAssignmentTicketsCollection;
        $scope.ticketReconciliationMapCollection = TicketReconciliationMapCollection;
        $scope.payPeriod = PayPeriod;

        $scope.taskAssignmentCollection.empty();
        $scope.guideAssignmentCollection.empty();
        $scope.guideAssignmentTicketsCollection.empty();
        $scope.ticketReconciliationMapCollection.empty();

        $scope.showArchiveTicketTypes = false;
        $scope.activeGuideAssignment = null;
        $scope.activeUser = null;
        $scope.editingAssignment = false;
        $scope.activeOrganization = null;
        $scope.activeTaskAssignment = null;
        $scope.isLoading = false;
        $scope.isSaving = false;

        $scope.orgEnabled = {
            constitutional : true,
            spirits : false
        };

        $scope.tinymceOptions = {
            plugins: 'lists',
            branding : false,
            menubar : 'edit format',
            browser_spellcheck : true,
            content_css : '/css/style.css'
        };

        $scope.ticketCounts = {};
        $scope.filteredGuideAssignments = {};
        $scope.filteredUsers = null;

        $scope.toggleOrganizations = function(which)
        {
            if (which === 'spirits')
            {
                $scope.orgEnabled.constitutional = !$scope.orgEnabled.constitutional;
            } else
            {
                $scope.orgEnabled.spirits = !$scope.orgEnabled.spirits;
            }
            $scope.reloadViewModels();
        };

        $scope.saveTickets = function()
        {
            $scope.isSaving = true;
            var promises = [];

            var tickets = $scope.filteredTicketTypes($scope.activeGuideAssignment.organization_id);
            tickets.forEach(function(ticketType)
            {
                var ticket = $scope.getTicket($scope.activeGuideAssignment, ticketType);
                promises.push(ticket.save());
            });
            promises.push($scope.activeGuideAssignment.save());

            $q.all(promises).then(function()
            {
                $scope.isSaving = false;
                $scope.reloadViewModels();
            });
        };

        $scope.reloadViewModels = function()
        {
            $scope.ticketCounts = {};
            $scope.filteredGuideAssignments = {};
            $scope.filteredUsers = null;
            $scope.filteredUsers = $scope.getFilteredUsers();
        };

        $scope.closeEditor = function()
        {
            $scope.activeTaskAssignment = $scope.activeOrganization =
                $scope.activeGuideAssignment = $scope.activeUser = null;
            $scope.editingAssignment = false;
        };

        $scope.editGuideAssignment = function(guideAssignment, user)
        {
            if (guideAssignment.guide_id/1 === user.id/1)
            {
                $scope.activeGuideAssignment = guideAssignment;
                $scope.activeUser = user;
                $scope.activeTaskAssignment = $scope.getTaskAssignmentById(guideAssignment.taskassignment_id);
                $scope.activeOrganization = $scope.getOrganization($scope.activeTaskAssignment.organization_id);
            }
        };

        $scope.isRenderingSlowed = function()
        {
            var start = new Date($scope.payPeriod.datePicker.start);
            var end   = new Date($scope.payPeriod.datePicker.end);

            var daysBetween = (Math.abs(start - end)/1000/60/60/24);
            return daysBetween >= 120;
        };

        $scope.updatePayPeriod = function(which, startEnd)
        {
            if ($scope.isLoading) { return; }

            $scope.isLoading = true;

            $scope.payPeriod.updatePayPeriod(which, startEnd, function()
            {
                var start = new Date($scope.payPeriod.datePicker.start);
                var end   = new Date($scope.payPeriod.datePicker.end);

                var promises = [];

                promises.push($scope.taskAssignmentCollection.reload(start, end));
                promises.push($scope.ticketReconciliationMapCollection.reload(start, end));

                $q.all(promises).then(function()
                {
                    $scope.guideAssignmentCollection.reload($scope.taskAssignmentCollection.collection).then(function()
                    {
                        $scope.guideAssignmentTicketsCollection.reload($scope.guideAssignmentCollection.collection).then(function()
                        {
                            $scope.isLoading = false;
                            $scope.reloadViewModels();
                        });
                    });
                });

            });
        };

        $scope.getTaskAssignments = function(day)
        {
            if (!$scope.orgEnabled.constitutional)
            {
                return $scope.taskAssignmentCollection.getTaskAssignments(day, 2);
            } else if (!$scope.orgEnabled.spirits)
            {
                return $scope.taskAssignmentCollection.getTaskAssignments(day, 1);
            }
            return $scope.taskAssignmentCollection.getTaskAssignments(day);
        };

        $scope.getTaskAssignmentById = function(id)
        {
            if ($scope.taskAssignmentCollection && $scope.taskAssignmentCollection.isLoaded)
            {
                return $scope.taskAssignmentCollection.getTaskAssignmentById(id);
            }
        };

        $scope.getGuideAssignmentByTaskId = function(id)
        {
            return ($scope.guideAssignmentCollection.collection.filter(function(assignment)
            {
                return assignment.taskassignment_id/1 === id/1;
            })).pop();
        };

        $scope.getGuideAssignmentsByUserId = function(user_id)
        {
            return $scope.guideAssignmentCollection.collection.filter(function(assignment)
            {
                return assignment.guide_id/1 === user_id/1;
            });
        };


        $scope.getFilteredGuideAssignments = function(dayDetails, user)
        {
            if ($scope.isLoading) { return []; }

            var dayKey = dayDetails && dayDetails.day ? dayDetails.day.getTime() : '_all';
            var userKey = user && user.id ? user.id : '_all';
            var day = dayDetails && dayDetails.day ? dayDetails.day : null;

            if ($scope.filteredGuideAssignments.hasOwnProperty(dayKey) && $scope.filteredGuideAssignments.hasOwnProperty(userKey))
            {
                return $scope.filteredGuideAssignments[dayKey][userKey];
            }

            if (!$scope.filteredGuideAssignments.hasOwnProperty(dayKey))
            {
                $scope.filteredGuideAssignments[dayKey] = { userKey : null };
            }

            if (!$scope.filteredGuideAssignments[dayKey].hasOwnProperty(userKey))
            {
                $scope.filteredGuideAssignments[dayKey][userKey] = null;
            }

            var filteredAssignments = $scope.getTaskAssignments(day).filter(function (taskAssignment)
            {
                return taskAssignment.tasktype / 1 === 1 && taskAssignment.tourtype / 1 === 1;
            });

            var assignmentIds = filteredAssignments.map(function(taskAssignment)
            {
                return taskAssignment.id/1;
            });

            $scope.filteredGuideAssignments[dayKey][userKey] = $scope.guideAssignmentCollection.collection.filter(function (guideAssignment)
            {
                if (user && guideAssignment.guide_id / 1 !== user.id / 1)
                {
                    return false;
                }
                if (!guideAssignment.status) { return false; }
                return dayDetails && assignmentIds.indexOf(guideAssignment.taskassignment_id) >= 0;
            });

            return $scope.filteredGuideAssignments[dayKey][userKey];
        };

        $scope.getTotalColTicketCount = function()
        {
            var totalTicketCount = 0;

            $scope.getFilteredUsers().forEach(function(user)
            {
                totalTicketCount += $scope.getColTicketCount(user);
            });

            return totalTicketCount;
        };

        $scope.getColTicketCount = function(user)
        {
            var totalUserCount = 0;

            $scope.payPeriod.activeDays.forEach(function (dayDetails)
            {
                var ticketCount = $scope.getTicketCount(dayDetails, user);
                totalUserCount += ticketCount ? ticketCount : 0;
            });

            return totalUserCount;
        };

        $scope.getMappedGuideAssignments = function(dayDetails)
        {
            var day_time = dayDetails && dayDetails.day ? dayDetails.day.getTime() : null;

            return $scope.ticketReconciliationMapCollection.collection.filter(function(ticketMap)
            {
                if ($scope.orgEnabled.constitutional && ticketMap.organization_id/1 !== 1) { return; }
                if ($scope.orgEnabled.spirits && ticketMap.organization_id/1 !== 2) { return; }

                var assignment_date = new Date(ticketMap.assignmentdate + ' 00:00:00');

                return assignment_date.getTime() === day_time;
            });
        };

        $scope.getMappedTicketCount = function(dayDetails, user)
        {
            var ticketCount = 0;
            var day_time = dayDetails && dayDetails.day ? dayDetails.day.getTime() : null;

            var found = false;

            $scope.ticketReconciliationMapCollection.collection.forEach(function(ticketMap)
            {
                if ($scope.orgEnabled.constitutional && ticketMap.organization_id/1 !== 1) { return; }
                if ($scope.orgEnabled.spirits && ticketMap.organization_id/1 !== 2) { return; }

                var assignment_date = new Date(ticketMap.assignmentdate + ' 00:00:00');

                if (day_time && assignment_date.getTime() !== day_time) { return; }

                if (!user)
                {
                    found = true;
                    ticketCount += ticketMap.totaltickets/1;
                } else if (ticketMap.guide_id/1 === user.id/1)
                {
                    found = true;
                    ticketCount += ticketMap.totaltickets/1;
                }
            });

            if (found) { return ticketCount; }
        };

        $scope.getTicketCount = function(dayDetails, user)
        {
            if ($scope.isLoading) { return null; }

            var dayKey = dayDetails && dayDetails.day ? dayDetails.day.getTime() : '_all';
            var userKey = user ? user.id : '_all';

            if ($scope.ticketCounts.hasOwnProperty(dayKey) && $scope.ticketCounts[dayKey].hasOwnProperty(userKey))
            {
                return $scope.ticketCounts[dayKey][userKey];
            }

            if (!$scope.ticketCounts.hasOwnProperty(dayKey))
            {
                $scope.ticketCounts[dayKey] = {};
                $scope.ticketCounts[dayKey][userKey] = null;
            }

            if (!$scope.ticketCounts[dayKey].hasOwnProperty(userKey))
            {
                $scope.ticketCounts[dayKey][userKey] = null;
            }

            var total = 0;

            var guideAssignments = $scope.getFilteredGuideAssignments(dayDetails, user);

            if (guideAssignments.length <= 0)
            {
                return $scope.ticketCounts[dayKey][userKey];
            }

            guideAssignments.forEach(function (guideAssignment)
            {
                total += guideAssignment.totaltickets ? guideAssignment.totaltickets : 0;
            });

            $scope.ticketCounts[dayKey][userKey] = total;

            return total;
        };

        $scope.getFilteredUsers = function()
        {
            if ($scope.filteredUsers) { return $scope.filteredUsers; }

            $scope.filteredUsers =  $scope.usersCollection.users.filter(function(user)
            {
                if (!user.status) { return false; }
                if (user.organization_constitutional && $scope.orgEnabled.constitutional) { return true; }
                if (user.organization_spirits && $scope.orgEnabled.spirits) { return true; }
            });

            return $scope.filteredUsers;
        };

        $scope.getOrganization = function(id)
        {
            for (var i=0; i<$scope.organizationsCollection.organizations.length; i++)
            {
                if ($scope.organizationsCollection.organizations[i].id/1 === id/1)
                {
                    return $scope.organizationsCollection.organizations[i];
                }
            }
        };

        $scope.getTourType = function(taskAssignment)
        {
            if (taskAssignment)
            {
                return ($scope.tourTypesCollection.tourTypes.filter(function (tourType)
                {
                    return tourType.id / 1 === taskAssignment.tourtype / 1;
                })).pop();
            }
        };

        $scope.getTaskType = function(taskAssignment)
        {
            if (taskAssignment)
            {
                return ($scope.taskTypesCollection.taskTypes.filter(function(taskType)
                {
                    return taskType.id / 1 === taskAssignment.tasktype / 1;
                })).pop();
            }
        };

        $scope.filteredTicketTypes = function(organizationId)
        {
            return $scope.ticketTypeCollection.collection.filter(function(ticketType)
            {
                if (!$scope.showArchiveTicketTypes && !ticketType.status) { return false; }
                return (ticketType.organization_id !== null && organizationId !== null) ?
                       ticketType.organization_id/1 === organizationId/1 : true;
            });
        };


        $scope.getTicketTotals = function(guideAssignment, column, ticketType)
        {
            if (!guideAssignment) { return null; }

            var totalAdult = 0, totalChild = 0, totalCombined = 0;

            var filteredTicketTypes = ticketType ? [ticketType] : $scope.filteredTicketTypes(guideAssignment.organization_id);

            var ticketsList = filteredTicketTypes.map(function(ticketType)
            {
                return $scope.getTicket(guideAssignment, ticketType);
            });

            ticketsList.map(function(ticket)
            {
                totalAdult    += ticket.adult    ? ticket.adult/1    : 0;
                totalChild    += ticket.child    ? ticket.child/1    : 0;
                totalCombined += ticket.combined ? ticket.combined/1 : 0;
            });

            var totalAll    = totalAdult    ? totalAdult    : 0;
            totalAll       += totalChild    ? totalChild    : 0;
            totalAll       += totalCombined ? totalCombined : 0;

            switch (column)
            {
                case 'adult':    return totalAdult    ? totalAdult    : null;
                case 'child':    return totalChild    ? totalChild    : null;
                case 'combined': return totalCombined ? totalCombined : null;
                default:         return totalAll      ? totalAll      : null;
            }
        };

        $scope.getTicket = function(guideAssignment, ticketType)
        {
            if (!guideAssignment || !ticketType) { return null; }

            var ticket = ($scope.guideAssignmentTicketsCollection.collection.filter(function(guideAssignmentTicket)
            {
                return guideAssignmentTicket.assignment_id/1 === guideAssignment.id/1 &&
                       guideAssignmentTicket.ticket_id/1 === ticketType.id;
            })).pop();

            if (!ticket)
            {
                ticket = new GuideAssignmentTicket();
                ticket.assignment_id = guideAssignment.id/1;
                ticket.ticket_id = ticketType.id/1;
                ticket.adult = ticketType.adult ? 0 : null;
                ticket.child = ticketType.child ? 0 : null;
                ticket.combined = ticketType.combined ? 0 : null;

                $scope.guideAssignmentTicketsCollection.collection.push(ticket);
            }

            return ticket;
        };

        var promises = [];

        promises.push($scope.usersCollection.load());
        promises.push($scope.organizationsCollection.load());
        promises.push($scope.taskTypesCollection.load());
        promises.push($scope.tourTypesCollection.load());
        promises.push($scope.ticketTypeCollection.load());

        $scope.isLoading = true;

        $q.all(promises).then(function()
        {
            $scope.isLoading = false;
            $scope.updatePayPeriod(0);
        });
    }]);

})($, angular, document, window);
