/**
 * OnFocus select all text - when focusing a text input, select all the text
 */
(function($, angular, document, window)
{
    var selectTimeout;

    angular.module('phillyByFoot')
    .directive('copyToClipboard', function () {
       return {
           restrict: 'A',
           link: function (scope, elem, attrs) {
               elem.click(function () {
                   if (attrs.copyToClipboard) {
                       var $temp_input = $("<input>");
                       $("body").append($temp_input);
                       $temp_input.val(attrs.copyToClipboard).select();
                       document.execCommand("copy");
                       $temp_input.remove();
                       $(elem).addClass('doing-copy');
                       setTimeout(function(){
                           $(elem).removeClass('doing-copy');
                       }, 2000);
                   }
               });
           }
       };
    });

})(jQuery, angular, document, window);
