/**
 * OnFocus select all text - when focusing a text input, select all the text
 */
(function($, angular, document, window)
{
    var selectTimeout;

    angular.module('phillyByFoot')
    .directive('selectOnFocus', ['$window', function($window)
    {
        return {
            restrict: 'A', // attribute only
            link : function(scope, element, attrs, ngModel)
            {
                element.on('focus', function()
                {

                    var input = this;

                    clearTimeout(selectTimeout);

                    /* timeout helps to make sure caret is in the input field before selecting, 100ms isn't too bad a FOUC */
                    selectTimeout = setTimeout(function()
                    {
                        input.setSelectionRange(0, input.value.length);
                    }, 100);
                });
            }
        };
    }]);

})(jQuery, angular, document, window);
