/**
 * accounting filter, will take a double provided and display as parenthized negative or non-parens positive currency or percent
 * { -0.1 | accounting:'%':2 } == (10.00%)
 * { -100 | accounting:'$':2 } == ($10.00)
 * { 0.1 | accounting:'%':2 } == 10.00%
 * { 100 | accounting:'$':2 } == $10.00
 *
 */
(function($, angular, document, window)
{
    angular.module('phillyByFoot')
    .filter('accounting', ['$sce','$filter', function($sce, $filter)
    {
        return function (input, prefix, decimals, postfix)
        {
            if ("" === input || undefined === input || null === input || isNaN(input)) { return ""; }

            prefix = prefix !== undefined ? prefix : '';
            postfix = postfix !== undefined ? postfix : '';
            ps = input < 0 ? "(" : "";
            pe = input < 0 ? postfix + ")" : postfix + "";


            input = Math.abs(input);
            input *= 10000;
            input = Math.round(input);
            input /= 10000;

            output = "";

            if      (prefix === '$') { output = ps + $filter('currency')(input, prefix, decimals) + pe;   }
            else if (prefix === '%') { output = ps + $filter('number')(input * 100, decimals) + '%' + pe; }
            else if (prefix === ':') { output = ps + $filter('number')(input, decimals) + ':1' + pe; }
            else if (prefix === 'F') { output = ps + $filter('number')(input, decimals) + pe; }
            else if (prefix === '')  { output = ps + $filter('number')(input, '') + pe;      }
            else                     { output = ps + $filter('number')(input, decimals) + ' ' + prefix + pe; }

            return output;
        };
    }]);

})(jQuery, angular, document, window);
