(function($, angular, document, window)
{
    angular.module('phillyByFoot')
    .filter('inYear', ['$filter', function($filter)
    {
        return function(list, element, year)
        {
            if(year)
            {
                return $filter("filter")(list, function(listItem)
                {
                    var startDate = new Date(year, 0, 1);
                    var endDate = new Date(year, 11, 31,23,59,59,999);
                    return (listItem[element] >= startDate && listItem[element] <= endDate);
                });
            }

            return $filter("filter")(list, function(listItem)
            {
                return true;
            });

        };
    }]);

})(jQuery, angular, document, window);
