(function($, angular, document, window)
{
    angular.module('phillyByFoot').factory('AppModelFactory',
        ['$http', '$log', '$q', '$location', 'SystemMessagingFactory',

         function($http, $log, $q, $location, SystemMessaging)
         {
             function AppModel() {}

             AppModel.prototype = {
                 urlBase : null,
                 exports : [],
                 propertyTypes : {
                     number : [],
                     bool   : [],
                     time   : []
                 },
                 isLoading : false,
                 isLoaded : false,
                 isSaving : false,
                 buildCallback : null,
                 hydrateCallback : null,
                 postHydrateCallback : null,
                 postSaveCallback : null,
                 getLoadUrl : function (){},
                 getSaveUrl : function (){},
                 getDeleteUrl : function(){},
                 getSaveMethod : function(){}
             };

             AppModel.prototype.reload = function()
             {
                 if (this.id)
                 {
                     this.isLoaded = false;
                     return this.load();
                 }
                 return $q.all([]);
             };

             AppModel.prototype.load = function()
             {
                 var self = this;

                 if (self.isLoaded) { return $q.all([]); }

                 return $http({
                     method : 'GET',
                     url : self.getLoadUrl()
                 }).then(function(response)
                 {
                     SystemMessaging.sendMessage(response.data);
                     self.hydrate(response.data);
                     return self;
                 }, function(response)
                 {
                     SystemMessaging.sendMessage(response.data);
                     return self;
                 });
             };

             AppModel.prototype.buildPostData = function()
             {
                 var self = this;

                 var postData = {};

                 for (var idx in self.exports)
                 {
                     var property = self.exports[idx];
                     postData[property] = self[property];

                     if (self.propertyTypes.number.indexOf(property) >= 0)
                     {
                         postData[property] /= 1;
                     }

                     if (self.propertyTypes.bool.indexOf(property) >= 0)
                     {
                         postData[property] = postData[property] ? 1 : 0;
                     }

                     if (self.propertyTypes.time.indexOf(property) >= 0 && self[property] !== null)
                     {
                         postData[property] = self[property].getHours() + ':' + self[property].getMinutes() + ':00';
                     }

                     if (self.hasOwnProperty('buildCallback') && typeof self.buildCallback === 'function')
                     {
                         self.buildCallback(property, postData);
                     }
                 }

                 return postData;
             };

             AppModel.prototype.deleteEntry = function()
             {
                 var self = this;
                 self.isSaving = self.isLoading = true;

                 return $http({
                     method : 'DELETE',
                     url    : self.getDeleteUrl(),
                     headers : { 'Content-Type' : 'application/x-www-form-urlencoded' },
                 }).then(function(response)
                 {
                     SystemMessaging.sendMessage(response.data);
                     self.hydrate(response.data);
                     self.isSaving = self.isLoading = false;
                     return self;
                 }, function(response)
                 {
                     SystemMessaging.sendMessage(response.data);
                     self.isSaving = self.isLoading = false;
                     return false;
                 });
             };

             AppModel.prototype.save = function()
             {
                 var self = this;
                 self.isSaving = self.isLoading = true;

                 var postData = self.buildPostData();

                 return $http({
                     method : self.getSaveMethod(),
                     url    : self.getSaveUrl(),
                     headers : { 'Content-Type' : 'application/x-www-form-urlencoded' },
                     data   : $.param( postData )
                 }).then(function(response)
                 {
                     SystemMessaging.sendMessage(response.data);
                     self.id = response.data.id;
                     // self.hydrate(response.data);
                     if (self.hasOwnProperty('postSaveCallback') && typeof self.postSaveCallback === 'function')
                     {
                         self.postSaveCallback(response.data);
                     }
                     self.isSaving = self.isLoading = false;
                     return self;
                 }, function(response)
                 {
                     SystemMessaging.sendMessage(response.data);
                     self.isSaving = self.isLoading = false;
                     return false;
                 });
             };

             AppModel.prototype.hydrate = function(data)
             {
                 var self = this;

                 for (var property in data)
                 {
                     if (!data.hasOwnProperty(property)) { continue; }

                     self[property] = data[property];

                     if (self.propertyTypes.number.indexOf(property) >= 0 && !isNull(self[property]))
                     {
                         self[property] /= 1;
                     }

                     if (self.propertyTypes.bool.indexOf(property) >= 0 && !isNull(self[property]))
                     {
                         self[property] = self[property]/1 === 1;
                     }

                     if (self.propertyTypes.time.indexOf(property) >= 0)
                     {
                         self[property] = new Date();
                         var hsm = !isNull(data[property]) && data[property].match(':') ? data[property].split(":") : [0,0];
                         self[property].setHours(hsm[0]);
                         self[property].setMinutes(hsm[1]);
                         self[property].setSeconds(0);
                         self[property].setMilliseconds(0);
                     }

                     if (self.hasOwnProperty('hydrateCallback') && typeof self.hydrateCallback === 'function')
                     {
                         self.hydrateCallback(property);
                     }
                 }
                 this.isLoaded = true;
                 this.isLoading = false;

                 if (self.hasOwnProperty('postHydrateCallback') && typeof self.postHydrateCallback === 'function')
                 {
                     self.postHydrateCallback();
                 }
             };

             return AppModel;

         }]);
})(jQuery, angular, document, window);
