(function ($, angular, document, window) {

    angular.module('phillyByFoot')
    .factory('AvailabilitiesCollectionFactory',
    ['$http', '$log', '$q', 'SystemMessagingFactory', 'AvailabilitiesFactory', 'AppModelCollectionFactory',
    function ($http, $log, $q, SystemMessaging, Availabilities, AppModelCollectionFactory)
    {


        function AvailabilitiesCollection()
        {
            var self = this;

            this.urlBase = '/wstr/api/availabilities';

            this.collection = [];
            this.guide_id = null;

            this.reload = function(guide_id)
            {
                self.guide_id = guide_id;
                self.isLoaded = false;
                return self.load();
            };

            this.getLoadUrl = function()
            {
                return self.urlBase + (self.guide_id ? '?guide_id=' + self.guide_id : '');
            };

            this.hydrateCallback = function(modelData)
            {
                var availability = new Availabilities();
                availability.hydrate(modelData);

                return availability;
            };
        }

        AvailabilitiesCollection.prototype = AppModelCollectionFactory.prototype;

        return new AvailabilitiesCollection();
    }]);
    
})(jQuery, angular, document, window);