(function($, angular, document, window)
{
    angular.module('phillyByFoot').factory('CalendarFactory',
    ['$q', '$filter', 'MonthsFactory', function($q, $filter, months)
    {
        function Calendar()
        {
            this.months = months;
            this.weekDays = ["Sunday","Monday","Tuesday","Wednesday","Thursday","Friday","Saturday"];
            this.weekDaysShort = ["Sun","Mon","Tue","Wed","Thu","Fri","Sat"];
            this.fullMonthNames = { Jan : 'January', Feb : 'February', Mar : 'March',
                Apr : 'April', May : 'May', Jun : 'June', Jul : 'July', Aug : 'August',
                Sep : 'September', Oct : 'October', Nov : 'November', Dec : 'December' };
            this.currentDate = new Date();
            this.selectedDate = new Date();
            this.selectedMonth = 'Jan';
            this.activeYear = new Date().getFullYear();

            this.years = [];

            for (var year = 2008; year <= new Date().getFullYear() + 5; year++)
            {
                this.years.push(year);
            }

            this.fullCalendar = { Jan : [], Feb : [], Mar : [], Apr : [], May : [],
                Jun : [], Jul : [], Aug : [], Sep : [], Oct : [], Nov : [], Dec : [] };

            this.month = [];

            for (var month in this.fullCalendar)
            {
                if (!this.fullCalendar.hasOwnProperty(month)) { continue; }

                var firstDayOfMonth = new Date(this.year, months.indexOf(month), 1, 0, 0, 0, 0);
                var currentDay = new Date(firstDayOfMonth.getFullYear(), firstDayOfMonth.getMonth(),
                    firstDayOfMonth.getDate(), 0, 0, 0, 0);
                var currentMonth = currentDay.getMonth();

                for (var i=0; i<37; i++)
                {
                    if (i < firstDayOfMonth.getDay())
                    {
                        this.fullCalendar[month][i] = null;
                        continue;
                    }
                    this.fullCalendar[month][i] = currentDay;
                    currentDay = new Date(currentDay.getFullYear(), currentDay.getMonth(), currentDay.getDate() + 1, 0, 0, 0);

                    if (currentDay.getMonth() > currentMonth) { break; }
                }
            }

        }

        Calendar.prototype.isCurrent = function(day)
        {
            var now = new Date();

            if (!day) { return false; }

            return now.getFullYear() === day.getFullYear() && now.getMonth() === day.getMonth() &&
                   now.getDate() === day.getDate();
        };

        Calendar.prototype.isBeginningOfTime = function()
        {
            var beginningOfTime = new Date(2008, 0, 1, 0, 0, 0);
            var currentDate = new Date(this.selectedDate.getFullYear(), this.selectedDate.getMonth(), 1, 0, 0, 0);
            return beginningOfTime.getTime() >= currentDate.getTime();
        };

        Calendar.prototype.isEndOfTime = function()
        {
            var endOfTime = new Date(new Date().getFullYear() + 5, 12, 0, 0, 0, 0);
            var currentDate = new Date(this.selectedDate.getFullYear(), this.selectedDate.getMonth(), 1, 0, 0, 0);
            return endOfTime.getTime() <= currentDate.getTime();
        };

        Calendar.prototype.nextMonth = function(callback)
        {
            this.selectedDate = new Date(this.selectedDate.getFullYear(),
                this.selectedDate.getMonth() + 1, 1, 0, 0, 0);
            this.updateMonth(callback);
        };

        Calendar.prototype.prevMonth = function(callback)
        {
            this.selectedDate = new Date(this.selectedDate.getFullYear(),
                this.selectedDate.getMonth() - 1, 1, 0, 0, 0);
            this.updateMonth(callback);
        };

        Calendar.prototype.setCalendarMonth = function(selectedMonth, callback)
        {
            if (!selectedMonth) { return; }

            var month = months.indexOf(selectedMonth);

            this.selectedDate = new Date(this.selectedDate.getFullYear(), month, 1, 0, 0, 0);
            this.updateMonth(callback);
        };

        Calendar.prototype.setCalendarYear = function(activeYear, callback)
        {
            if (!activeYear) { return; }

            this.selectedDate = new Date(activeYear, this.selectedDate.getMonth(), 1, 0, 0, 0);
            this.updateMonth(callback);
        };

        Calendar.prototype.updateMonth = function(callback)
        {
            var firstDayOfMonth = new Date(this.selectedDate.getFullYear(),
                this.selectedDate.getMonth(), 1, 0, 0, 0, 0);
            var currentDay = new Date(firstDayOfMonth.getFullYear(),
                firstDayOfMonth.getMonth(), firstDayOfMonth.getDate(), 0, 0, 0, 0);

            var currentMonth = currentDay.getMonth();

            for (var x=0; x<37; x++) { this.month[x] = null; }

            for (var i=0; i<37; i++)
            {
                if (i < firstDayOfMonth.getDay())
                {
                    this.month[i] = null;
                    continue;
                }
                this.month[i] = currentDay;
                currentDay = new Date(currentDay.getFullYear(),
                    currentDay.getMonth(), currentDay.getDate() + 1, 0, 0, 0);

                if (currentDay.getMonth() > currentMonth) { break; }
            }

            var lastDayOfMonth = null;

            for (var f=0; f<this.month.length; f++)
            {
                var day = this.month[f];
                if (day)
                {
                    lastDayOfMonth = day;
                }
            }

            this.activeYear = this.selectedDate.getFullYear();
            this.selectedMonth = this.months[this.selectedDate.getMonth()];

            if (callback && typeof callback === 'function')
            {
                callback(firstDayOfMonth, lastDayOfMonth);
            }
        };

        return new Calendar();
    }]);

})(jQuery, angular, document, window);
