(function ($, angular, document, window) {

    angular.module('phillyByFoot')
    .factory('DayTypesCollectionFactory',
    ['$http', '$log', '$q', 'SystemMessagingFactory', 'DayTypeFactory',
    function ($http, $log, $q, SystemMessaging, DayType)
    {
        var urlBase = '/wstr/api/day-type';

        function DayTypesCollection()
        {
            this.isLoaded = false;
            this.dayTypes = [];
        }

        DayTypesCollection.prototype.load = function()
        {
            var self = this;

            if (this.isLoaded) { return $q.all([]); }

            return $http({
                method : 'GET',
                url : urlBase
            }).then(function(response)
            {
                SystemMessaging.sendMessage(response.data);
                self.hydrate(response.data);
                return self;
            }, function(response)
            {
                SystemMessaging.sendMessage(response.data);
                return self;
            });
        };

        DayTypesCollection.prototype.hydrate = function(data)
        {
            for (var i in data)
            {
                var dayTypeData = data[i];
                var dayTypeObject = new DayType();
                dayTypeObject.hydrate(dayTypeData);
                this.dayTypes.push(dayTypeObject);
            }
            this.isLoaded = true;
        };

        DayTypesCollection.prototype.deleteDayType = function(dayType)
        {
            var found = this.dayTypes.filter(function(element)
            {
                return element.id/1 !== dayType.id/1;
            });
            this.dayTypes = found;

            return dayType.deleteDayType();
        };

        return new DayTypesCollection();
    }]);
    
})(jQuery, angular, document, window);