(function($, angular, document, window)
{
    angular.module('phillyByFoot').factory('GuideAvailabilityFactory',
    ['$http', '$log', '$q', '$location', 'SystemMessagingFactory',
    function($http, $log, $q, $location, SystemMessaging)
    {
        var urlBase = '/wstr/api/guide-availabilities';
        var exports = ['id', 'guide_id', 'availabilitydate', 'starttime', 'endtime', 'notes',
                       'custom', 'createdate', 'modifydate'];

        function GuideAvailability()
        {
            this.id = this.guide_id = this.availabilitydate = this.starttime = this.endtime =
                this.notes = this.custom = this.createdate = this.modifydate;
            this.isLoaded = false;
            this.isLoading = false;
            this.isSaving = false;

            this.start_hour = null;
            this.start_minute = null;
            this.end_hour = null;
            this.end_minute = null;
        }

        GuideAvailability.prototype.updateAvailabilityTime = function()
        {
            this.starttime = new Date(this.availabilitydate + ' 00:00:00');
            this.endtime = new Date(this.availabilitydate + ' 00:00:00');

            this.starttime.setHours(this.start_hour/1);
            this.starttime.setMinutes(this.start_minute/1);
            this.endtime.setHours(this.end_hour/1);
            this.endtime.setMinutes(this.end_minute/1);

        };

        GuideAvailability.prototype.reload = function()
        {
            this.isLoaded = false;
            return this.load();
        };

        GuideAvailability.prototype.load = function()
        {
            if (this.isLoaded) { return $q.all([]); }

            var self = this;

            return $http({
                method : 'GET',
                url : urlBase + '/' + this.id
            }).then(function(response)
            {
                SystemMessaging.sendMessage(response.data);
                self.hydrate(response.data);
                return self;
            }, function(response)
            {
                SystemMessaging.sendMessage(response.data);
                return self;
            });
        };


        GuideAvailability.prototype.buildPostData = function()
        {
            var postData = {};

            for (var idx in exports)
            {
                var property = exports[idx];
                postData[property] = this[property];

                if (['status','custom'].indexOf(property) !== -1)
                {
                    postData[property] = this[property] ? 1 : 0;
                }

                if (['starttime','endtime'].indexOf(property) !== -1)
                {
                    postData[property] = this[property].getHours() + ':' + this[property].getMinutes() + ':00';
                }

            }

            return postData;
        };

        GuideAvailability.prototype.deleteEntry = function()
        {
            var self = this;
            this.isSaving = this.isLoading = true;

            return $http({
                method : 'DELETE',
                url    : urlBase + '/' + this.id,
                headers : { 'Content-Type' : 'application/x-www-form-urlencoded' },
            }).then(function(response)
            {
                SystemMessaging.sendMessage(response.data);
                self.hydrate(response.data);
                self.isSaving = self.isLoading = false;
                return self;
            }, function(response)
            {
                SystemMessaging.sendMessage(response.data);
                self.isSaving = self.isLoading = false;
                return false;
            });
        };

        GuideAvailability.prototype.save = function()
        {
            var self = this;
            this.isSaving = this.isLoading = true;

            var postData = this.buildPostData();

            return $http({
                method : this.id !== undefined && this.id !== null ? 'PUT' : 'POST',
                url    : this.id !== undefined && this.id !== null ? urlBase + '/' + this.id : urlBase,
                headers : { 'Content-Type' : 'application/x-www-form-urlencoded' },
                data   : $.param( postData )
            }).then(function(response)
            {
                SystemMessaging.sendMessage(response.data);
                    self.hydrate(response.data);
                    self.isSaving = self.isLoading = false;
                    return self;
            }, function(response)
            {
                SystemMessaging.sendMessage(response.data);
                self.isSaving = self.isLoading = false;
                return false;
            });
        };

        GuideAvailability.prototype.hydrate = function(data)
        {
            for (var property in data)
            {
                if (!data.hasOwnProperty(property)) { continue; }

                this[property] = data[property];

                if (['id', 'guide_id'].indexOf(property) >= 0)
                {
                    this[property] /= 1;
                }

                if (property === 'custom')
                {
                    this[property] = this[property]/1 === 1;
                }

                if (['starttime', 'endtime'].indexOf(property) >= 0)
                {
                    this[property] = new Date();
                    var hsm = data[property].split(":");
                    this[property].setHours(hsm[0]);
                    this[property].setMinutes(hsm[1]);
                    this[property].setSeconds(0);
                    this[property].setMilliseconds(0);

                    switch (property)
                    {
                        case 'starttime':
                            this.start_hour = hsm[0]/1;
                            this.start_minute = hsm[1]/1;
                            break;
                        case 'endtime':
                            this.end_hour = hsm[0]/1;
                            this.end_minute = hsm[1]/1;
                            break;
                    }
                }
            }

            this.isLoaded = true;
            this.isLoading = false;
            this.updateAvailabilityTime();
        };


        return GuideAvailability;

    }]);

})(jQuery, angular, document, window);
