(function($, angular, document, window)
{
    angular.module('phillyByFoot').factory('GuideShiftAssignmentFactory',
    ['$http', '$log', '$q', '$location', 'SystemMessagingFactory', 'AppModelFactory',
    function($http, $log, $q, $location, SystemMessaging, AppModel)
    {

        function GuideShiftAssignment()
        {
            var self = this;

            this.id = this.guide_id = this.shiftassignment_id = this.assignmentdate = null;

            this.urlBase = '/wstr/api/guide-shift-assignments';

            this.exports = ['id', 'shiftassignment_id', 'guide_id', 'assignmentdate'];

            this.propertyTypes = {
                number : ['id', 'shiftassignment_id', 'guide_id'],
                bool   : [ ],
                time   : [ ]
            };

            this.getSaveUrl = function ()
            {
                return self.id !== undefined && self.id !== null ?
                    self.urlBase + '/' + self.id : self.urlBase;
            };

            this.getSaveMethod = function()
            {
                return self.id !== undefined && self.id !== null ? 'PUT' : 'POST';
            };

            this.getLoadUrl = function()
            {
                return self.urlBase;
            };

            this.getDeleteUrl = function()
            {
                return self.urlBase + '/' + self.id;
            };
        }

        GuideShiftAssignment.prototype = AppModel.prototype;


        return GuideShiftAssignment;

    }]);

})(jQuery, angular, document, window);
