(function ($, angular, document, window) {

    angular.module('phillyByFoot')
    .factory('GuideShiftAssignmentCollectionFactory',
    ['$http', '$log', '$q', 'SystemMessagingFactory', 'GuideShiftAssignmentFactory', 'AppModelCollectionFactory',
    function ($http, $log, $q, SystemMessaging, GuideShiftAssignment, AppModelCollectionFactory)
    {
        function GuideShiftAssignmentCollection()
        {
            var self = this;
            this.urlBase = '/wstr/api/guide-shift-assignments';

            self.shiftAssignmentIds = null;

            this.reload = function(shiftAssignmentIds)
            {
                self.collection = [];
                self.isLoaded = false;
                self.shiftAssignmentIds = shiftAssignmentIds;
                return self.load();
            };

            this.getLoadUrl = function()
            {
                return self.urlBase + ('?shiftAssignmentIds=' + (self.shiftAssignmentIds ? self.shiftAssignmentIds.join(',') : null));
            };


            this.hydrateCallback = function(modelData)
            {
                var guideShiftAssignment = new GuideShiftAssignment();
                guideShiftAssignment.hydrate(modelData);

                return guideShiftAssignment;
            };
        }

        GuideShiftAssignmentCollection.prototype = AppModelCollectionFactory.prototype;

        return new GuideShiftAssignmentCollection();
    }]);
    
})(jQuery, angular, document, window);