(function ($, angular, document, window) {

    angular.module('phillyByFoot')
    .factory('GuideTimeSheetCollectionFactory',
    ['$http', '$log', '$q', '$filter', 'SystemMessagingFactory', 'GuideTimeSheetFactory', 'AppModelCollectionFactory',
    function ($http, $log, $q, $filter, SystemMessaging, GuideTimeSheet, AppModelCollectionFactory)
    {
        function GuideTimeSheetCollection()
        {
            var self = this;
            this.urlBase = '/wstr/api/guide-time-sheets';

            this.startDate = this.endDate = null;

            this.reload = function(startDate, endDate)
            {
                self.isLoaded = false;
                self.startDate = $filter('date')(startDate, 'yyyy-MM-dd');
                self.endDate = $filter('date')(endDate, 'yyyy-MM-dd');
                return this.load();
            };

            this.getLoadUrl = function()
            {
                return self.urlBase + "?startDate=" + self.startDate + "&endDate=" + self.endDate;
            };

            this.hydrateCallback = function(modelData)
            {
                var guideTimeSheet = new GuideTimeSheet();
                guideTimeSheet.hydrate(modelData);

                return guideTimeSheet;
            };

            this.getTimeSheets = function(date, organization_id)
            {
                return self.collection.filter(function(timeSheet)
                {
                    if (organization_id && (organization_id/1 !== timeSheet.organization_id)) { return false; }

                    var timeSheetDate = new Date(timeSheet.assignmentdate + ' 00:00:00');

                    return (date.getFullYear() === timeSheetDate.getFullYear() &&
                            date.getMonth()    === timeSheetDate.getMonth() &&
                            date.getDate()     === timeSheetDate.getDate());
                });
            };
        }

        GuideTimeSheetCollection.prototype = AppModelCollectionFactory.prototype;

        return new GuideTimeSheetCollection();
    }]);
    
})(jQuery, angular, document, window);
