/**
 * Just a useful service to provide a list of months
 */
(function($, angular, document, window)
{
    angular.module('phillyByFoot')
    .factory('IntraControllerActionHandlerFactory', ['$rootScope', '$location', function($scope, $location)
    {
        function IntraControllerActionHandler()
        {
            this.action = null;
            this.model = null;
            this.date = null;
            this.stopEvents = false;
            this.returnPath = null;

            this.priorAction = null;
            this.priorModel  = null;
            this.priorDate = null;
            this.priorReturnPath = null;

            var self = this;

            IntraControllerActionHandler.prototype.returnToPreviousController = function()
            {
                this.model = this.priorModel;
                this.action = this.priorAction;
                this.date = this.priorDate;
                this.returnPath = this.priorReturnPath;
                this.stopEvents = false;
                this.priorAction = null;
                this.priorDate = null;
                this.priorModel = null;
                this.priorReturnPath = null;

                $location.path($scope.returnPath);
            };

            $scope.$on('$routeChangeStart', function($event)
            {
                if(self.stopEvents && (self.action||self.model||self.date))
                {
                    if (!confirm("Warning! You may have unsaved changes. Do you wish to continue?"))
                    {
                        if ($event.hasOwnProperty('preventDefault') && typeof $event.preventDefault === 'function')
                        {
                            $event.preventDefault();
                        }
                        if ($event.hasOwnProperty('stopPropagation') && typeof $event.stopPropagation === 'function')
                        {
                            $event.stopPropagation();
                        }
                    } else
                    {
                        // self.action = null;
                        // self.model = null;
                        // self.date = null;
                        self.stopEvents = false;
                    }
                }
            });

            window.addEventListener("beforeunload", function (e)
            {
                if (self.stopEvents && (self.action || self.model || self.date))
                {
                    var confirmationMessage = "Warning! You may have unsaved changes.  Do you wish to continue?";
                    e.returnValue = confirmationMessage;     // Gecko, Trident, Chrome 34+
                    return confirmationMessage;              // Gecko, WebKit, Chrome <34
                }
            });
        }

        return new IntraControllerActionHandler();
    }]);

})(jQuery, angular, document, window);
