(function($, angular, document, window)
{
    var payPeriodStart = new Date('05/31/2008');
    var payPeriodEnd = new Date(new Date().getFullYear(), new Date().getMonth(), new Date().getDate());
    var payInterval = 14;

    angular.module('phillyByFoot').factory('PayPeriodFactory', ['$q', '$filter',
    function($q, $filter)
    {
        function PayPeriod()
        {
            this.period = -1;
            this.datePicker = {
                start : $filter('date')(payPeriodStart, 'MMM dd, yyyy'),
                end : $filter('date')(payPeriodEnd, 'MMM dd, yyyy')
            };
            this.activeDays = [];
        }

        PayPeriod.prototype = {
            period : -1,
            datePicker : {
                start : $filter('date')(payPeriodStart, 'MMM dd, yyyy'),
                end   :$filter('date')(payPeriodEnd, 'MMM dd, yyyy')
            },
            activeDays : []
        };

        PayPeriod.prototype.updatePayPeriod = function(which, startEnd, callback)
        {
            var periodStartDate, start, end;

            if (!startEnd)
            {
                periodStartDate = new Date(payPeriodStart);

                /**
                 * Find the first pay period past today
                 */
                do {
                    periodStartDate = periodStartDate.addDays(payInterval);
                } while (periodStartDate < payPeriodEnd);

                this.period += which/1;

                /**
                 * Get current pay period start
                 */
                periodStartDate = periodStartDate.addDays(payInterval * this.period);

                this.datePicker.start = $filter('date')(periodStartDate, 'MMM dd, yyyy');
                this.datePicker.end = $filter('date')(periodStartDate.addDays(payInterval - 1), 'MMM dd, yyyy');
            } else
            {
                /**
                 * We need to update this.period to find what period we're in when we change either
                 * the start date or end date using the calendar selector, so that the next time we click
                 * the next/previous buttons, we'll be on the next/previous pay period from the start entry
                 */

                start = new Date(this.datePicker.start);
                end   = new Date(this.datePicker.end);

                if (start > end)
                {
                    if (startEnd === 'start')
                    {
                        this.datePicker.end = $filter('date')(start.addDays(payInterval - 1), 'MMM dd, yyyy');
                    } else
                    {
                        this.datePicker.start = $filter('date')(end.addDays(payInterval * -1), 'MMM dd, yyyy');
                    }
                }

                periodStartDate = new Date(payPeriodStart);

                do {
                    periodStartDate = periodStartDate.addDays(payInterval);
                } while (periodStartDate < payPeriodEnd);

                periodStartDate = periodStartDate.addDays(payInterval * this.period);

                var currentStartDate = new Date(this.datePicker.start);

                if (currentStartDate < periodStartDate)
                {
                    do {
                        periodStartDate = periodStartDate.addDays(payInterval * -1);
                        this.period--;
                    } while (currentStartDate < periodStartDate);
                } else if (currentStartDate > periodStartDate)
                {
                    do {
                        periodStartDate = periodStartDate.addDays(payInterval);
                        this.period++;
                    } while (currentStartDate > periodStartDate);
                }
            }

            start = new Date(this.datePicker.start);
            end   = new Date(this.datePicker.end);

            var days = [];

            while (start <= end)
            {
                days.push({ day : start });
                start = start.addDays(1);
            }

            this.activeDays = days;

            if (callback && typeof callback === 'function')
            {
                callback(this);
            }
        };


        return new PayPeriod();
    }]);

})(jQuery, angular, document, window);
