(function($, angular, document, window)
{
    angular.module('phillyByFoot').factory('ReservedDateFactory',
    ['$http', '$log', '$q', '$location', 'SystemMessagingFactory', 'AppModelFactory',
    function($http, $log, $q, $location, SystemMessaging, AppModel)
    {

        function ReservedDate()
        {
            var self = this;

            this.id = this.guide_id = this.organization_id = this.reserveddate = this.reserved = this.emaildate = null;

            this.urlBase = '/wstr/api/reserved-dates';

            this.changed = false;
            this.initialReserved = false;
            this.exports = ['id', 'guide_id', 'organization_id', 'reserveddate','reserved','emaildate'];

            this.propertyTypes = {
                number : ['id', 'guide_id', 'organization_id'],
                bool   : ['reserved'],
                time   : []
            };

            this.getSaveUrl = function ()
            {
                if (!isNull(self.id) && !$.isNumeric(self.id) && self.id.match('new_')) { self.id = null; }
                self.changed = false;
                self.initialReserved = self.reserved;

                return self.id !== undefined && self.id !== null ?
                    self.urlBase + '/' + self.id : self.urlBase;
            };

            this.getSaveMethod = function()
            {
                if (!isNull(self.id) && !$.isNumeric(self.id) && self.id.match('new_')) { self.id = null; }
                self.changed = false;
                self.initialReserved = self.reserved;

                return self.id !== undefined && self.id !== null ? 'PUT' : 'POST';
            };

            this.getLoadUrl = function()
            {
                return self.urlBase;
            };

            this.getDeleteUrl = function()
            {
                return self.urlBase + '/' + self.id;
            };

            this.buildCallback = function(property, model)
            {
            };

            this.hydrateCallback = function(property)
            {
                if (property === 'emaildate' && self[property])
                {
                    self[property] = new Date(self[property]);
                }
                if (property === 'reserved')
                {
                    self.initialReserved = self[property];
                }
            };

        }

        ReservedDate.prototype = AppModel.prototype;


        return ReservedDate;

    }]);

})(jQuery, angular, document, window);
