(function ($, angular, document, window) {

    angular.module('phillyByFoot')
    .factory('ReservedDateCollectionFactory',
    ['$http', '$log', '$q', '$filter', 'SystemMessagingFactory', 'ReservedDateFactory', 'AppModelCollectionFactory',
    function ($http, $log, $q, $filter, SystemMessaging, ReservedDate, AppModelCollection)
    {
        function ReservedDateCollection()
        {
            var self = this;
            this.urlBase = '/wstr/api/reserved-dates';
            this.collection = [];

            this.startDate = this.endDate = null;

            this.reload = function(startDate, endDate)
            {
                self.isLoaded = false;
                self.startDate = $filter('date')(startDate, 'yyyy-MM-dd');
                self.endDate = $filter('date')(endDate, 'yyyy-MM-dd');
                return this.load();
            };

            this.getLoadUrl = function()
            {
                return self.urlBase + "?startDate=" + self.startDate + "&endDate=" + self.endDate;
            };

            this.hydrateCallback = function(modelData)
            {
                var reservedDate = new ReservedDate();
                reservedDate.hydrate(modelData);

                return reservedDate;
            };
        }

        ReservedDateCollection.prototype = AppModelCollection.prototype;

        return new ReservedDateCollection();
    }]);
    
})(jQuery, angular, document, window);