(function($, angular, document, window)
{
    angular.module('phillyByFoot').factory('SeasonFactory',
    ['$http', '$log', '$q', '$location', 'SystemMessagingFactory',

     function($http, $log, $q, $location, SystemMessaging)
     {
         var urlBase = '/wstr/api/seasons';
         var exports = ['id', 'organization_id', 'name', 'startdate', 'enddate', 'status',
            'createdate', 'modifydate'];

         function Season()
         {
             this.id = this.organization_id = this.name = this.startdate = this.enddate =
                 this.status = this.createdate = this.modifydate = null;
             this.isLoaded = false;
             this.isLoading = false;
             this.isSaving = false;
         }

         Season.prototype.load = function()
         {
             if (this.isLoaded) { return $q.all([]); }

             var self = this;

             return $http({
                 method : 'GET',
                 url : urlBase + '/' + this.id
             }).then(function(response)
             {
                 SystemMessaging.sendMessage(response.data);
                 self.hydrate(response.data);
                 return self;
             }, function(response)
             {
                 SystemMessaging.sendMessage(response.data);
                 return self;
             });
         };


         Season.prototype.buildPostData = function()
         {
             var postData = {};

             for (var idx in exports)
             {
                 var property = exports[idx];
                 postData[property] = this[property];

                 if (property === 'status')
                 {
                     postData[property] = this.status ? 1 : 0;
                 }
             }

             return postData;
         };

         Season.prototype.deleteSeason = function()
         {
             var self = this;
             this.isSaving = this.isLoading = true;

             return $http({
                 method : 'DELETE',
                 url    : urlBase + '/' + this.id,
                 headers : { 'Content-Type' : 'application/x-www-form-urlencoded' },
             }).then(function(response)
             {
                 SystemMessaging.sendMessage(response.data);
                 self.hydrate(response.data);
                 self.isSaving = self.isLoading = false;
                 return self;
             }, function(response)
             {
                 SystemMessaging.sendMessage(response.data);
                 self.isSaving = self.isLoading = false;
                 return false;
             });
         };

         Season.prototype.save = function(clone)
         {

             var self = this;
             this.isSaving = this.isLoading = true;

             var model_id = clone ? clone : this.id;

             var postData = this.buildPostData();

             return $http({
                 method : model_id !== undefined && model_id !== null ? 'PUT' : 'POST',
                 url    : model_id !== undefined && model_id !== null ? urlBase + '/' + model_id : urlBase,
                 headers : { 'Content-Type' : 'application/x-www-form-urlencoded' },
                 data   : $.param( postData )
             }).then(function(response)
             {
                 SystemMessaging.sendMessage(response.data);
                 self.hydrate(response.data);
                 self.isSaving = self.isLoading = false;
                 return self;
             }, function(response)
             {
                 SystemMessaging.sendMessage(response.data);
                 self.isSaving = self.isLoading = false;
                 return false;
             });
         };

         Season.prototype.hydrate = function(data)
         {
             for (var property in data)
             {
                 if (!data.hasOwnProperty(property)) { continue; }

                 this[property] = data[property];

                 if (property === 'id' || property === 'organization_id')
                 {
                     this[property] /= 1;
                 }
                 if (property === 'status')
                 {
                     this[property] = data[property]/1 === 1;
                 }
             }
             this.isLoaded = true;
             this.isLoading = false;
         };


         return Season;

     }]);
})(jQuery, angular, document, window);
