(function ($, angular, document, window) {

    angular.module('phillyByFoot')
    .factory('ShiftAssignmentsCollectionFactory',
    ['$http', '$log', '$q', 'SystemMessagingFactory', 'ShiftAssignmentFactory',
    function ($http, $log, $q, SystemMessaging, ShiftAssignment)
    {
        var urlBase = '/wstr/api/shift-assignments';

        function ShiftAssignmentsCollection()
        {
            this.isLoaded = false;
            this.assignments = [];
        }

        ShiftAssignmentsCollection.prototype.empty = function()
        {
            this.isLoaded = this.isLoading = false;
            this.assignments = [];
        };

        ShiftAssignmentsCollection.prototype.reload = function(weekdayAssignmentId, shiftAssignmentIds)
        {
            this.empty();
            if (weekdayAssignmentId == null && (!(shiftAssignmentIds instanceof Array) || shiftAssignmentIds.length <= 0))
            {
                return $q.all([]);
            }
            return this.load(weekdayAssignmentId, shiftAssignmentIds);
        };

        ShiftAssignmentsCollection.prototype.load = function(weekdayAssignmentId, shiftAssignmentIds)
        {
            var self = this;

            if (this.isLoaded) { return $q.all([]); }

            var getUrl = urlBase +
                         ("?weekdayAssignmentId=" + (weekdayAssignmentId ? weekdayAssignmentId : null)) +
                         ("&shiftAssignmentIds=" + (shiftAssignmentIds ? shiftAssignmentIds.join(',') : null));

            return $http({
                method : 'GET',
                url : getUrl
            }).then(function(response)
            {
                SystemMessaging.sendMessage(response.data);
                self.hydrate(response.data);
                return self;
            }, function(response)
            {
                SystemMessaging.sendMessage(response.data);
                return self;
            });
        };

        ShiftAssignmentsCollection.prototype.hydrate = function(data)
        {
            var newAssignments = [];
            for (var i in data)
            {
                var assignmentData = data[i];
                var assignmentObject = new ShiftAssignment();
                assignmentObject.hydrate(assignmentData);
                newAssignments.push(assignmentObject);
            }
            this.assignments = newAssignments;
            this.isLoaded = true;
        };

        ShiftAssignmentsCollection.prototype.deleteEntry = function(assignment)
        {
            var found = this.assignments.filter(function(element)
            {
                return element.id/1 !== assignment.id/1;
            });
            this.assignments = found;

            return assignment.deleteEntry();
        };

        return new ShiftAssignmentsCollection();
    }]);
    
})(jQuery, angular, document, window);