/**
 * The sates factory
 */
(function ($, angular, document, window)
{
    angular.module('phillyByFoot') /* grab the module and register the userDataFactory */
    .factory('StatesFactory', ['$http', 'SystemMessagingFactory',
    function ($http, SystemMessaging)
    {

        var States = function()
        {
            this.isLoaded = false;
        };

        States.prototype.load = function()
        {
            if (this.isLoaded) { return $q.all([]); }

            var self = this;

            $http({
                method: 'GET',
                url: '/js/States.json'
            }).then(function (response)
            {
                SystemMessaging.sendMessage(response.data);
                self.states = response.data;
                this.isLoaded = true;
            }, function(response)
            {
                SystemMessaging.sendMessage(response.data);
            });
        };

        var states = new States();
        states.load();
        return states;
    }]);

})(jQuery, angular, document, window);
