(function($, angular, document, window)
{
    angular.module('phillyByFoot').factory('TaskFactory',
    ['$http', '$log', '$q', '$location', 'SystemMessagingFactory',
    function($http, $log, $q, $location, SystemMessaging)
    {
        var urlBase = '/wstr/api/tasks';
        var exports = ['id', 'shift_id', 'tasktype', 'starttime', 'endtime', 'status',
            'createdate', 'modifydate'];

        /* can use prototypical inheritance, and object can behave like a real object and not just a dictionary */
        function Task()
        {
            this.id = this.shift_id = this.tasktype = this.starttime = this.endtime =
                this.status = this.createdate = this.modifydate = null;
            this.isLoaded = false;
            this.isLoading = false;
            this.isSaving = false;

            this.start_hour = null;
            this.start_minute = null;
            this.end_hour = null;
            this.end_minute = null;

        }

        Task.prototype.updateTaskTime = function()
        {

            if (this.starttime === null)
            {
                this.starttime = new Date();
                this.starttime.setHours(6);
                this.starttime.setMinutes(0);
                this.starttime.setSeconds(0);
                this.starttime.setMilliseconds(0);
            }

            if (this.endtime === null)
            {
                this.endtime = new Date();
                this.endtime.setHours(6);
                this.endtime.setMinutes(0);
                this.endtime.setSeconds(0);
                this.endtime.setMilliseconds(0);
            }

            this.starttime.setHours(this.start_hour/1);
            this.starttime.setMinutes(this.start_minute/1);
            this.endtime.setHours(this.end_hour/1);
            this.endtime.setMinutes(this.end_minute/1);
        };


        Task.prototype.load = function()
        {
            if (this.isLoaded) { return $q.all([]); }

            var self = this;

            return $http({
                method : 'GET',
                url : urlBase + '/' + this.id
            }).then(function(response)
            {
                SystemMessaging.sendMessage(response.data);
                self.hydrate(response.data);
                return self;
            }, function(response)
            {
                SystemMessaging.sendMessage(response.data);
                return self;
            });
        };


        Task.prototype.buildPostData = function()
        {
            var postData = {};

            for (var idx in exports)
            {
                var property = exports[idx];
                postData[property] = this[property];

                if (property === 'status')
                {
                    postData[property] = this.status ? 1 : 0;
                }

                if (['starttime','endtime'].indexOf(property) !== -1)
                {
                    postData[property] = this[property].getHours() + ':' + this[property].getMinutes() + ':00';
                }
            }

            return postData;
        };

        Task.prototype.deleteTask = function()
        {
            var self = this;
            this.isSaving = this.isLoading = true;

            return $http({
                method : 'DELETE',
                url    : urlBase + '/' + this.id,
                headers : { 'Content-Type' : 'application/x-www-form-urlencoded' },
            }).then(function(response)
            {
                SystemMessaging.sendMessage(response.data);
                self.hydrate(response.data);
                self.isSaving = self.isLoading = false;
                return self;
            }, function(response)
            {
                SystemMessaging.sendMessage(response.data);
                self.isSaving = self.isLoading = false;
                return false;
            });
        };

        Task.prototype.save = function()
        {
            var self = this;
            this.isSaving = this.isLoading = true;

            var postData = this.buildPostData();

            return $http({
                method : this.id !== undefined && this.id !== null ? 'PUT' : 'POST',
                url    : this.id !== undefined && this.id !== null ? urlBase + '/' + this.id : urlBase,
                headers : { 'Content-Type' : 'application/x-www-form-urlencoded' },
                data   : $.param( postData )
            }).then(function(response)
            {
                SystemMessaging.sendMessage(response.data);
                    // self.hydrate(response.data);
                    self.id = response.data.id/1;
                    self.isSaving = self.isLoading = false;
                    return self;
            }, function(response)
            {
                SystemMessaging.sendMessage(response.data);
                self.isSaving = self.isLoading = false;
                return false;
            });
        };
        
        Task.prototype.hydrate = function(data)
        {
            for (var property in data)
            {
                if (!data.hasOwnProperty(property)) { continue; }

                this[property] = data[property];

                if (['id', 'shift_id', 'tasktype'].indexOf(property) !== -1)
                {
                    this[property] /= 1;
                }
                if (property === 'status')
                {
                    this[property] = this[property]/1 === 1;
                }
                if (['starttime','endtime'].indexOf(property) !== -1)
                {
                    this[property] = new Date();
                    var hsm = data[property].split(":");
                    this[property].setHours(hsm[0]);
                    this[property].setMinutes(hsm[1]);
                    this[property].setSeconds(0);
                    this[property].setMilliseconds(0);

                    switch (property)
                    {
                        case 'starttime':
                            this.start_hour = hsm[0]/1;
                            this.start_minute = hsm[1]/1;
                            break;
                        case 'endtime':
                            this.end_hour = hsm[0]/1;
                            this.end_minute = hsm[1]/1;
                            break;
                    }
                }
            }
            this.isLoaded = true;
            this.isLoading = false;
        };

        return Task;

    }]);

})(jQuery, angular, document, window);
