(function ($, angular, document, window) {

    angular.module('phillyByFoot')
    .factory('TaskCollectionFactory',
    ['$http', '$log', '$q', 'SystemMessagingFactory', 'TaskFactory',
    function ($http, $log, $q, SystemMessaging, Task)
    {
        var urlBase = '/wstr/api/tasks';

        function TaskCollection()
        {
            this.isLoaded = false;
            this.tasks = [];
        }

        TaskCollection.prototype.load = function()
        {
            var self = this;

            if (this.isLoaded) { return $q.all([]); }

            return $http({
                method : 'GET',
                url : urlBase
            }).then(function(response)
            {
                SystemMessaging.sendMessage(response.data);
                self.hydrate(response.data);
                return self;
            }, function(response)
            {
                SystemMessaging.sendMessage(response.data);
                return self;
            });
        };

        TaskCollection.prototype.hydrate = function(data)
        {
            for (var i in data)
            {
                var taskData = data[i];
                var taskObject = new Task();
                taskObject.hydrate(taskData);
                this.tasks.push(taskObject);
            }
            this.isLoaded = true;
        };

        TaskCollection.prototype.deleteTask = function(task)
        {
            var foundTasks = this.tasks.filter(function(element)
            {
                return element.id/1 !== task.id/1;
            });
            this.tasks = foundTasks;

            return task.deleteTask();
        };

        return new TaskCollection();
    }]);
    
})(jQuery, angular, document, window);